/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
refresh_job_control_status();
run_primer();
rerun_d3plot();

/**
 * #AAW REPORTER run PRIMER rerun D3PLOT
 *
 * Refreshes the value of JOB_CONTROL and checks for Abort.
 */
function refresh_job_control_status() {
    LogPrint(`Checking job control status...`);
    generate_item(`#AAW REPORTER read variables from PRIMER job control`);

    let template = Template.GetCurrent();
    let job_control = template.GetVariableValue(`JOB_CONTROL`);
    LogPrint(`Job control status is: "${job_control}"`);
    if (job_control == `Abort`) {
        LogPrint(`Generation aborted (job control).`);
        Exit();
    }
}

/**
 * #AAW REPORTER run PRIMER rerun D3PLOT
 *
 * Runs the `#AAW PRIMER user data GUI` item if necessary.
 */
function run_primer() {
    let template = Template.GetCurrent();

    /* Check whether we need to run PRIMER*/
    let job_control = template.GetVariableValue(`JOB_CONTROL`);
    /* check if need to launch another perimer gui item */
    let primer_gui = template.GetVariableValue(`AAW_PRIMER_USER_DATA_GUI`);
    if (job_control == `Check`) {
        if (primer_gui) {
            generate_item(primer_gui);
        } else {
            generate_item(`#AAW PRIMER user data GUI`);
        }
        refresh_job_control_status();
    }
}

/**
 * #AAW REPORTER run PRIMER rerun D3PLOT
 *
 * Reruns the `#AAW D3PLOT check and do assessment` item if necessary.
 * Rerunning is necessary if the check of report contents against user data failed
 * the first time and the PRIMER GUI was launched to give the user the opportunity
 * to update the user data.
 */
function rerun_d3plot() {
    let template = Template.GetCurrent();

    /* Check whether we need to rerun D3PLOT item*/
    let job_control = template.GetVariableValue(`JOB_CONTROL`);
    if (job_control == `Skip`) {
        LogPrint(`No need to rerun D3PLOT item.`);
        return;
    }
    if (job_control != `Run`) {
        LogError(`Unexpected value of <JOB_CONTROL = ${job_control}> in function rerun_d3plot.`);
        return;
    }

    /* If we reach here, then we need to rerun D3PLOT item. Because we are running it for the
     * second time, we won't check report contents against user data, so we proceed directly to
     * running the occupant assessment. Hence update JOB_CONTROL: */
    let job_control_var = new Variable(
        template,
        `JOB_CONTROL`,
        `"Check"/"Run"/"Skip"/"Abort" for #AAW items`,
        `Run`,
        `String`,
        false,
        true
    );
    LogPrint(`Start rerunning D3PLOT for the second time.`);
    generate_item(`#AAW D3PLOT check and do assessment`);
}
