// DESCRIPTION: This REPORTER JavaScript sets the previously deactivated script items active again
//              after the template has been generated.
//              This will only reactivate the items on the FIRST page, reverting the template back to
//              its original state.

// Main code is enclosed in IIFE so that variables declared on each script item will not be
// exposed to other script items in the Reporter template.
(() => {
    let templ = Template.GetCurrent();
    let page = templ.GetPage(0); // FIRST PAGE...
    activate_script_items(page, true);

    // Do not reactivate this item!
    let run_template = Item.GetFromName(page, "AutoRunTemplate");
    run_template.active = false;
})();

/**
 * Activate (or deactivate) all script items in the current page of the given template.
 *
 * This only supports items of type: {@link Item.SCRIPT}, {@link Item.PRIMER}, {@link Item.D3PLOT},
 * {@link Item.THIS}, {@link Item.PROGRAM}, {@link Item.LIBRARY_PROGRAM}
 * @param {Page} page - Page to find script items
 * @param {Boolean=} activate - True to activate, false to deactivate
 * @param {String[]=} item_names - List of item names in the page to activate/deactivate.
 * If undefined, this function will take all the items in the page instead.
 */
function activate_script_items(page, activate = true, item_names = []) {
    // Get only script items
    let script_items = (
        item_names.length == 0
            ? Item.GetAll(page)
            : item_names.map((x) => Item.GetFromName(page, x)).filter((y) => y !== null)
    ).filter(
        (x) =>
            x.type == Item.SCRIPT ||
            x.type == Item.PRIMER ||
            x.type == Item.THIS ||
            x.type == Item.D3PLOT ||
            x.type == Item.PROGRAM ||
            x.type == Item.LIBRARY_PROGRAM
    );

    // Reactivate script items
    script_items.forEach((item) => (item.active = activate));
}
