// DESCRIPTION: This REPORTER Javascript is invoked by script item 'ScriptOnLoad'. This will generate
//              the rest of the template except ScriptOnLoad, which should be inactive already.
//
//              When users abort the operation upon opening this Reporter template, this script item
//              is deactivated. Therefore, when the users manually generate the entire report,
//              this script_item will not run, preventing the template to be run twice.

// Main code is enclosed in IIFE so that variables declared on each script item will not be
// exposed to other script items in the Reporter template.
(() => {
    let templ = Template.GetCurrent();
    let page = templ.GetPage(0);

    //  Set this script inactive so when we generate the whole template, we don't generate this script again
    let this_script_item = Item.GetFromName(page, "AutoRunTemplate");
    this_script_item.active = false;

    templ.Generate();

    // Note: This script item will be permanently inactive after it is called.
})();
