/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */

initialise_variables();

/** Duplicate page and update the image item path based on number of channels output */
function initialise_variables() {
    let template = Template.GetCurrent();

    let testname = new Variable(template, "testName", "Test name", "MISSING INPUT", "string");
    let labName = new Variable(template, "labName", "Laboratory name", "MISSING INPUT", "string");
    let customerName = new Variable(template, "customerName", "Customer name", "MISSING INPUT", "string");
    let customerTestRefNumber = new Variable(
        template,
        "customerTestRefNumber",
        "Customer test ref number",
        "MISSING INPUT",
        "string"
    );
    let customerProjectRefNumber = new Variable(
        template,
        "customerProjectRefNumber",
        "Customer project ref number",
        "MISSING INPUT",
        "string"
    );
    let virtualTestingReferenceId = new Variable(
        template,
        "virtualTestingReferenceId",
        "Virtual testing ref ID",
        "MISSING INPUT",
        "string"
    );
    let typeOfTest = new Variable(template, "typeOfTest", "Type of test", "MISSING INPUT", "string");
    let isoMmeFormat = new Variable(template, "isoMmeFormat", "Format version", "MISSING INPUT", "string");
    let subtypeOfTest = new Variable(template, "subtypeOfTest", "Subtype of test", "MISSING INPUT", "string");
    let testDate = new Variable(template, "testDate", "Test data", "MISSING INPUT", "string");
    let requiredOutputChannelCsv = new Variable(
        template,
        "requiredOutputChannelCsv",
        "Required output channel CSV",
        "MISSING INPUT",
        "string"
    );
    let outputDirectory = new Variable(template, "outputDirectory", "Output directory", "MISSING INPUT", "string");
    let title = new Variable(template, "title", "Title", "MISSING INPUT", "string");
    let regulation = new Variable(template, "regulation", "Regulation", "MISSING INPUT", "string");
    let typeOfDataSource = new Variable(template, "typeOfDataSource", "Type of data source", "MISSING INPUT", "string");
    let dummySimModelSpec = new Variable(
        template,
        "dummySimModelSpec",
        "Dummy Simulation Model specification",
        "MISSING INPUT",
        "string"
    );
    let refDummyQualDoc = new Variable(
        template,
        "refDummyQualDoc",
        "Reference Dummy Qualification Document",
        "MISSING INPUT",
        "string"
    );
    let solverName = new Variable(template, "solverName", "Solver name", "MISSING INPUT", "string");
    let solverVersion = new Variable(template, "solverVersion", "Solver version", "MISSING INPUT", "string");
    let solverPrecision = new Variable(template, "solverPrecision", "Solver precision", "MISSING INPUT", "string");
    let platformName = new Variable(template, "platformName", "Platform name", "MISSING INPUT", "string");
    let numberOfCpus = new Variable(template, "numberOfCpus", "Number of CPUs", "MISSING INPUT", "string");
    let timestepSetting = new Variable(template, "timestepSetting", "Time step settings", "MISSING INPUT", "string");
    let contactTypeBwDummySeat = new Variable(
        template,
        "contactTypeBwDummySeat",
        "Contact type between Dummy and seat",
        "MISSING INPUT",
        "string"
    );
    let contactTypeBwDummySeatbelt = new Variable(
        template,
        "contactTypeBwDummySeatbelt",
        "Contact type between dummy and seatbelt",
        "MISSING INPUT",
        "string"
    );
    let numberOfContacts = new Variable(template, "numberOfContacts", "Number of contacts", "MISSING INPUT", "string");
    let numberOfElements = new Variable(template, "numberOfElements", "Number of elements", "MISSING INPUT", "string");
    let massOfTotalSetup = new Variable(template, "massOfTotalSetup", "Mass of total setup", "MISSING INPUT", "string");
    let massOfDummy = new Variable(template, "massOfDummy", "Mass of dummy", "MISSING INPUT", "string");
    let massOfSeat = new Variable(template, "massOfSeat", "Mass of seat", "MISSING INPUT", "string");
    let massOfSled = new Variable(template, "massOfSled", "Mass of sled", "MISSING INPUT", "string");
    let massOfCentreConsole = new Variable(
        template,
        "massOfCentreConsole",
        "Mass of centre console",
        "MISSING INPUT",
        "string"
    );
    let distBwHeadCogGreenLine = new Variable(
        template,
        "distBwHeadCogGreenLine",
        "Distance between head COG and green line",
        "MISSING INPUT",
        "string"
    );
    let distBwHeadCogYellowLine = new Variable(
        template,
        "distBwHeadCogYellowLine",
        "Distance between head COG and yellow line",
        "MISSING INPUT",
        "string"
    );
    let distBwHeadCogOrangeLine = new Variable(
        template,
        "distBwHeadCogOrangeLine",
        "Distance between head COG and orange line",
        "MISSING INPUT",
        "string"
    );
    let distBwHeadCogRedLine = new Variable(
        template,
        "distBwHeadCogRedLine",
        "Distance between head COG and red line",
        "MISSING INPUT",
        "string"
    );

    let vehicleName = new Variable(template, "vehicleName", "Vehicle name", "MISSING INPUT", "string");

    let vehicleRefNumber = new Variable(
        template,
        "vehicleRefNumber",
        "Vehicle reference number",
        "MISSING INPUT",
        "string"
    );

    let vehicleLongVelocity = new Variable(
        template,
        "vehicleLongVelocity",
        "Vehicle longitudinal velocity",
        "MISSING INPUT",
        "string"
    );

    let vehicleLatVelocity = new Variable(
        template,
        "vehicleLatVelocity",
        "Vehicle lateral velocity",
        "MISSING INPUT",
        "string"
    );

    let vehicleMass = new Variable(template, "vehicleMass", "Vehicle mass", "MISSING INPUT", "string");
}
