/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
draw_occupant_images();

/**
 * Draw occupant body region scoring indicator images for the specified models
 */

function draw_occupant_images() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let output_dir = get_expanded_variable_value(templ, `OUTPUT_DIR`);

    /* Checks if the output directory provided is valid */
    if (is_valid_output_dir(output_dir) == false) {
        LogPrint("Invalid output directory");
        return;
    }
    let occupants = ["DRIVER"];

    for (let m of models) {
        for (let occ of occupants) {
            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };
            draw_ratings_bar_USNCAP(output_dir, m, occ);

            let head_hic = get_variable_value(status, `${m}_${occ}_HEAD_HIC_SCORE`, "float");
            let pelvis_score = get_variable_value(status, `${m}_${occ}_PELVIS_FORCE_SCORE`, "float");

            if (!status.success) {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} body region score indicator images`);
            }

            /* Create new image */
            let img = new Image(300, 342);
            img.lineWidth = 1;
            img.lineColour = "black";
            const BLACK_COL = "#000000";
            /* Draw the body regions */

            draw_side_view_head(img, get_fill_colour_USNCAP(head_hic));
            draw_side_view_pelvis(img, get_fill_colour_USNCAP(pelvis_score));

            draw_side_view_neck(img, get_fill_colour_USNCAP(null)); //defalut color is White
            draw_side_view_chest(img, get_fill_colour_USNCAP(null));
            draw_side_view_abdomen(img, get_fill_colour_USNCAP(null));
            draw_side_view_right_arm(img, get_fill_colour_USNCAP(null));
            draw_side_view_right_leg(img, get_fill_colour_USNCAP(null));

            if (occ == "DRIVER") {
                draw_side_view_steering_wheel(img, BLACK_COL);
            }

            img.Save(`${output_dir}/${m}_${occ.toLowerCase()}_plot.png`, Image.PNG);
        }
    }
}
