/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
overall_score();

/**
 * Performs the overall score calculation for the specified models
 */
function overall_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();

    let occupants = ["DRIVER", "REAR_DRIVER_SIDE"];

    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} probability score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            switch (occ) {
                case "DRIVER": {
                    let head_prob = get_variable_value(status, `${m}_${occ}_HEAD_HIC_SCORE`, "float");
                    let pelvis_prob = get_variable_value(status, `${m}_${occ}_PELVIS_FORCE_SCORE`, "float");
                    let chest_prob = get_variable_value(status, `${m}_${occ}_CHEST_COMPRESSION_SCORE`, "float");
                    let abdomen_prob = get_variable_value(status, `${m}_${occ}_ABDOMEN_FORCE_MAX_SCORE`, "float");

                    let input_scores = [head_prob, pelvis_prob, chest_prob, abdomen_prob];

                    /* If we have all the required variables, calculate the final scores */
                    if (status.success) {
                        let joint_probability = calculate_joint_probability_USNCAP(input_scores);
                        let relative_risk = calculate_relative_risk_USNCAP(joint_probability);

                        let total_prob_var = new Variable(
                            templ,
                            `${m}_${occ}_JOINT_PROB`,
                            `${occ} joint probability`,
                            joint_probability.toString(),
                            "String",
                            false,
                            true
                        );

                        let relative_risk_var = new Variable(
                            templ,
                            `${m}_${occ}_RELATIVE_RISK`,
                            `${occ} relative risk`,
                            relative_risk.toString(),
                            "String",
                            false,
                            true
                        );
                    } else {
                        warn_about_missing_or_invalid_variables(status, `${m} ${occ} overall score calculation`);
                    }

                    break;
                }

                case "REAR_DRIVER_SIDE": {
                    let head_prob = get_variable_value(status, `${m}_${occ}_HEAD_HIC_SCORE`, "float");
                    let pelvis_prob = get_variable_value(status, `${m}_${occ}_PELVIS_FORCE_SCORE`, "float");

                    let input_scores = [head_prob, pelvis_prob];
                    /* If we have all the required variables, calculate the final scores */
                    if (status.success) {
                        /*Calculate Probability function calculates the net probability for the assessment by taking an array of probability scores*/
                        let joint_probability = calculate_joint_probability_USNCAP(input_scores);

                        /* Calculates the relative risk from the joint probability value computed above. */
                        let relative_risk = calculate_relative_risk_USNCAP(joint_probability);

                        let total_prob_var = new Variable(
                            templ,
                            `${m}_${occ}_JOINT_PROB`,
                            `${occ} joint probability`,
                            joint_probability.toString(),
                            "String",
                            false,
                            true
                        );

                        let relative_risk_var = new Variable(
                            templ,
                            `${m}_${occ}_RELATIVE_RISK`,
                            "RELATIVE RISK REAR DRIVER",
                            relative_risk.toString(),
                            "String",
                            false,
                            true
                        );
                    } else {
                        warn_about_missing_or_invalid_variables(status, `${m} ${occ} overall score calculation`);
                    }

                    break;
                }

                default:
                    LogError(`Unexpected occupant type "${occ}".`);
                    Exit();
            }
        }
    }
}
