/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
chest_score();

/**
 * Performs the chest score calculation for the specified models
 */
function chest_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `chest`;

    let occupants = ["DRIVER"];
    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Chest score */
            let chest_compression_lower;
            let chest_compression_mid;
            let chest_compression_upper;
            let chest_compression_lower_score;
            let chest_compression_mid_score;
            let chest_compression_upper_score;

            switch (occ) {
                case "DRIVER":
                    chest_compression_lower = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_LOWER_MAX_VALUE`,
                        "float"
                    );

                    chest_compression_mid = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_MIDDLE_MAX_VALUE`,
                        "float"
                    );

                    chest_compression_upper = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_UPPER_MAX_VALUE`,
                        "float"
                    );

                    chest_compression_lower_score = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_LOWER_MAX_SCORE`,
                        "float"
                    );

                    chest_compression_mid_score = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_MIDDLE_MAX_SCORE`,
                        "float"
                    );

                    chest_compression_upper_score = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_UPPER_MAX_SCORE`,
                        "float"
                    );
                    break;
                default:
                    LogError(`Unexpected occupant type "${occ}" in ${body_region_label} calculation.`);
                    Exit();
            }

            /* Final max value will start at zero and will remain so if any variables were missing or invalid */
            /* Final score will start at one and will remain so if any variables were missing or invalid */
            let chest_compression_max_value = 0;
            let chest_compression_score = 1;

            /* If we have all the required variables, calculate the final scores */

            if (status.success) {
                /* Score calculation is different for different occupants */

                switch (occ) {
                    case "DRIVER":
                        /*The chest score is maximum of all the values*/

                        chest_compression_max_value = Math.max(
                            Math.max(chest_compression_lower, chest_compression_mid),
                            chest_compression_upper
                        );

                        chest_compression_score = Math.max(
                            Math.max(chest_compression_lower_score, chest_compression_mid_score),
                            chest_compression_upper_score
                        );
                        break;

                    default:
                        LogError(`Unexpected occupant type "${occ}" in ${body_region_label} calculation.`);
                        Exit();
                }

                LogPrint(`${m} ${occ} chest score = ${chest_compression_max_value}`);
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            if (occ == "DRIVER") {
                let chest_compression_final_score_var = new Variable(
                    templ,
                    `${m}_${occ}_CHEST_COMPRESSION_MAX_VALUE`,
                    `Maximum ${body_region_label} compression`,
                    chest_compression_max_value.toString(),
                    "String",
                    false,
                    true
                );

                let chest_compression_score_var = new Variable(
                    templ,
                    `${m}_${occ}_CHEST_COMPRESSION_SCORE`,
                    `Maximum ${body_region_label} compression score`,
                    chest_compression_score.toString(),
                    "String",
                    false,
                    true
                );
            }
        }
    }
}
