draw_images();

function draw_images() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let output_dir = get_expanded_variable_value(templ, `OUTPUT_DIR`);

    /* Checks if the output directory provided is valid */
    if (is_valid_output_dir(output_dir) == false) {
        LogPrint("Invalid output directory");
        return;
    }

    let occupants = ["DRIVER", "FRONT_PASSENGER"];

    for (let m of models) {
        for (let occ of occupants) {
            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            draw_ratings_bar_USNCAP(output_dir, m, occ);

            switch (occ) {
                case "DRIVER": {
                    let img = new Image(300, 342);

                    let head_hic = get_variable_value(status, `${m}_${occ}_HEAD_HIC_SCORE`, "float");
                    let chest_score = get_variable_value(status, `${m}_${occ}_CHEST_COMPRESSION_SCORE`, "float");
                    let left_femur = get_variable_value(status, `${m}_${occ}_LEFT_FEMUR_COMPRESSION_SCORE`, "float");
                    let neck_score = get_variable_value(status, `${m}_${occ}_NECK_INJURY_PROB`, "float");
                    let right_femur = get_variable_value(status, `${m}_${occ}_RIGHT_FEMUR_COMPRESSION_SCORE`, "float");

                    draw_front_view_head(img, get_fill_colour_USNCAP(head_hic));
                    draw_front_view_neck(img, get_fill_colour_USNCAP(neck_score));
                    draw_front_view_chest(img, get_fill_colour_USNCAP(chest_score));
                    draw_front_view_abdomen(img, get_fill_colour_USNCAP(null));
                    draw_front_view_right_arm(img, "DRIVER");
                    draw_front_view_left_arm(img, "DRIVER");
                    draw_front_view_right_femur(img, get_fill_colour_USNCAP(right_femur));
                    draw_front_view_left_femur(img, get_fill_colour_USNCAP(left_femur));
                    draw_front_view_right_tibia(img, get_fill_colour_USNCAP(null));
                    draw_front_view_left_tibia(img, get_fill_colour_USNCAP(null));
                    draw_front_view_left_foot(img, get_fill_colour_USNCAP(null));
                    draw_front_view_right_foot(img, get_fill_colour_USNCAP(null));

                    draw_front_view_steering_wheel(img);
                    draw_front_view_seatbelt(img, "DRIVER");

                    //Write out the image
                    img.Save(`${output_dir}/${m}_${occ.toLowerCase()}_plot.png`, Image.PNG);

                    break;
                }

                case "FRONT_PASSENGER": {
                    let img = new Image(300, 342);

                    let head_hic = get_variable_value(status, `${m}_${occ}_HEAD_HIC_SCORE`, "float");
                    let chest_score = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_PASSENGER_SCORE`,
                        "float"
                    );
                    let left_femur = get_variable_value(
                        status,
                        `${m}_${occ}_LEFT_FEMUR_COMPRESSION_PASSENGER_SCORE`,
                        "float"
                    );
                    let neck_score = get_variable_value(status, `${m}_${occ}_NECK_INJURY_PROB`, "float");
                    let right_femur = get_variable_value(
                        status,
                        `${m}_${occ}_RIGHT_FEMUR_COMPRESSION_PASSENGER_SCORE`,
                        "float"
                    );

                    draw_front_view_head(img, get_fill_colour_USNCAP(head_hic));
                    draw_front_view_neck(img, get_fill_colour_USNCAP(neck_score));
                    draw_front_view_chest(img, get_fill_colour_USNCAP(chest_score));
                    draw_front_view_abdomen(img, get_fill_colour_USNCAP(null));
                    draw_front_view_right_femur(img, get_fill_colour_USNCAP(right_femur));
                    draw_front_view_left_femur(img, get_fill_colour_USNCAP(left_femur));
                    draw_front_view_right_tibia(img, get_fill_colour_USNCAP(null));
                    draw_front_view_left_tibia(img, get_fill_colour_USNCAP(null));
                    draw_front_view_left_foot(img, get_fill_colour_USNCAP(null));
                    draw_front_view_right_foot(img, get_fill_colour_USNCAP(null));
                    draw_front_view_right_arm(img, get_fill_colour_USNCAP(null));
                    draw_front_view_left_arm(img, get_fill_colour_USNCAP(null));
                    draw_front_view_seatbelt(img, "FRONT_PASSENGER");

                    //Write out the image
                    img.Save(`${output_dir}/${m}_${occ.toLowerCase()}_plot.png`, Image.PNG);

                    break;
                }

                default:
                    LogError(`Unexpected occupant type "${occ}"`);
                    Exit();
            }
        }
    }
}
