/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
overall_score();

/**
 * Performs overall score calculation for the specified models
 */
function overall_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `overall`;

    let occupants = ["DRIVER"];
    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            let variable_values = get_multiple_variable_values(
                status,
                [
                    `${m}_${occ}_HEAD_RATING`,
                    `${m}_${occ}_CHEST_RATING`,
                    `${m}_${occ}_PELVIS_RATING`,
                    `${m}_${occ}_ABDOMEN_RATING`
                ],
                "string",
                true
            );

            /*Overall score variable is initially set to False */
            let overall_rating = "Fail";

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                overall_rating = return_pass_or_fail(Object.values(variable_values));
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            let overall = new Variable(
                templ,
                `${m}_${occ}_RATING`,
                `${occ} overall rating`,
                overall_rating,
                "String",
                false,
                true
            );
        }
    }
}
