/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
head_and_neck_score();

/**
 * Performs the head and neck calculation for the specified models
 */
function head_and_neck_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `head and neck`;

    let occupants = ["DRIVER", "FRONT_PASSENGER"];
    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Head and neck ratings */

            let head_variable_values = get_multiple_variable_values(
                status,
                [`${m}_${occ}_HEAD_HIC_RATING`, `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_RATING`],
                "string",
                true
            );

            let neck_variable_values = get_multiple_variable_values(
                status,
                [
                    `${m}_${occ}_NECK_SHEAR_EXCEEDENCE_RATING`,
                    `${m}_${occ}_NECK_TENSION_EXCEEDENCE_RATING`,
                    `${m}_${occ}_NECK_EXTENSION_RATING`
                ],
                "string",
                true
            );

            /* Final ratings are set to fail and will remain so if any variables were missing or invalid */

            let overall_head_rating = "Fail";
            let overall_neck_rating = "Fail";
            let overall_head_and_neck_rating = "Fail";

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                overall_head_rating = return_pass_or_fail(Object.values(head_variable_values));
                overall_neck_rating = return_pass_or_fail(Object.values(neck_variable_values));

                overall_head_and_neck_rating = return_pass_or_fail([overall_head_rating, overall_neck_rating]);
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            new Variable(
                templ,
                `${m}_${occ}_HEAD_AND_NECK_RATING`,
                `${occ} overall head and neck rating`,
                overall_head_and_neck_rating,
                "String",
                false,
                true
            );

            new Variable(
                templ,
                `${m}_${occ}_HEAD_RATING`,
                `${occ} overall head rating`,
                overall_head_rating,
                "String",
                false,
                true
            );

            new Variable(
                templ,
                `${m}_${occ}_NECK_RATING`,
                `${occ} overall neck rating`,
                overall_neck_rating,
                "String",
                false,
                true
            );
        }
    }
}
