/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
structural_rating();

/**
 * Performs the evaulatuion for the vehicle strucutre
 */
function structural_rating() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `vehicle structure`;

    for (let m of models) {
        LogPrint(`Calculating ${m} ${body_region_label} score...`);

        /* Create a status object to track whether REPORTER Variables are all present and valid.
         * <success> is initially true but will be set to false if anything missing or invalid. */
        let status = { success: true, missing: [], invalid: [] };

        /*Structural Rating */

        let steering_wheel_vert_rating = get_variable_value(
            status,
            `${m}_STRUCTURE_STEERING_COLUMN_VERTICAL_INTRUSION_RATING`,
            "string"
        );

        let steering_wheel_fore_aft_rating = get_variable_value(
            status,
            `${m}_STRUCTURE_STEERING_COLUMN_FORE_AFT_INTRUSION_RATING`,
            "string"
        );

        let door_opening_mod = get_variable_value(status, `${m}_DOOR_OPENING_MODIFIER`, "string");

        /*Set door opening rating to fail and overall rating to fail */
        let door_opening_rating = "Fail";
        let overall_structural_rating = "Fail";

        /*If we have all the required values, calculate the final values */
        if (status.success) {
            if (
                door_opening_mod == "No" &&
                steering_wheel_vert_rating == "Pass" &&
                steering_wheel_fore_aft_rating == "Pass"
            ) {
                door_opening_rating = "Pass";
                overall_structural_rating = "Pass";
            }
        } else {
            warn_about_missing_or_invalid_variables(status, `${m} ${body_region_label} score calculation`);
        }

        new Variable(templ, `${m}_DOOR_RATING`, `${m} door opening rating`, door_opening_rating, "String", false, true);

        new Variable(
            templ,
            `${m}_STRUCTURAL_RATING`,
            `${m} overall structural rating`,
            overall_structural_rating,
            "String",
            false,
            true
        );
    }
}
