/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
abdomen_score();

/**
 * Performs the abdomen score calculation for the specified models
 */
function abdomen_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `abdomen`;

    let occupants = ["DRIVER"];
    for (let m of models) {
        let capping_limit_explanation = "";
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Abdomen score and modifiers */
            let lowerspine_3ms_score;

            let comp_scores = get_multiple_variable_values(
                status,
                [`${m}_${occ}_ABDOMEN_COMPRESSION_MAX_01_SCORE`, `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_02_SCORE`],
                "float",
                true
            );

            let vc_ratings = get_multiple_variable_values(
                status,
                [
                    `${m}_${occ}_ABDOMEN_VISCOUS_CRITERION_UPPER_MAX_RATING`,
                    `${m}_${occ}_ABDOMEN_VISCOUS_CRITERION_LOWER_MAX_RATING`
                ],
                "string",
                true
            );

            let capping_limits = get_multiple_variable_values(
                status,
                [
                    `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_01_CAPPING_LIMIT`,
                    `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_02_CAPPING_LIMIT`
                ],
                "string",
                true
            );

            let incorrect_airbag_mod = get_variable_value(
                status,
                `${m}_ABDOMEN_INCORRECT_AIRBAG_DEPLOYMENT_MODIFIER`,
                "int"
            );

            lowerspine_3ms_score = get_variable_value(
                status,
                `${m}_${occ}_LOWERSPINE_THREE_MS_EXCEEDENCE_RATING`,
                "string"
            );

            let abdomen_vc_mod = return_pass_or_fail(Object.values(vc_ratings));

            new Variable(
                templ,
                `${m}_${occ}_ABDOMEN_VISCOUS_CRITERION_MODIFIER`,
                "Abdomen VC Modifier",
                abdomen_vc_mod.toString(),
                "String",
                false,
                true
            );

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let abdomen_score = 0;
            let abdomen_score_before_mods = 0;

            /* Capping limits start as exceeded and will remain so if any variables were missing or invalid */
            let abdomen_capping_limit = "*";

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                /* Score calculation is different for different occupants */
                /* Abdomen score is minimum of top and bottom scores */
                abdomen_score_before_mods = Math.min(...Object.values(comp_scores));

                abdomen_score = Math.max(0, abdomen_score_before_mods + incorrect_airbag_mod);

                /* Check capping limits. If any individual limits are exceeded, an asterisk is
                 * displayed for all parent body regions. */

                if (return_capping_limit(Object.values(capping_limits)) == "") {
                    abdomen_capping_limit = "";
                } else {
                    capping_limit_explanation = `*Capping limit exceeded`;
                }

                /* Check if the abdomen vc criterion has passed and set the score to 0 if not */
                if (abdomen_vc_mod == "Fail") {
                    if (capping_limit_explanation == "") {
                        capping_limit_explanation += `Abdomen viscous criterion limit exceeded`;
                    } else {
                        capping_limit_explanation += `, Abdomen viscous criterion limit exceeded`;
                    }

                    abdomen_score = 0;
                }

                if (lowerspine_3ms_score == "Fail") {
                    if (capping_limit_explanation == "") {
                        capping_limit_explanation += `Lowerspine 3ms acceleration limit exceeded`;
                    } else {
                        capping_limit_explanation += `, Lowerspine 3ms acceleration limit exceeded`;
                    }

                    abdomen_score = 0;
                }
                /* Only report abdomen score for driver */
                LogPrint(`${m} ${occ} abdomen score = ${abdomen_score}`);
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            new Variable(
                templ,
                `${m}_${occ}_ABDOMEN_FINAL_SCORE`,
                "Final abdomen score",
                abdomen_score.toString(),
                "String",
                false,
                true
            );
            new Variable(
                templ,
                `${m}_${occ}_ABDOMEN_CAPPING_LIMIT`,
                `Abdomen capping limit`,
                abdomen_capping_limit,
                "String",
                false,
                true
            );

            new Variable(
                templ,
                `${m}_ABDOMEN_CAPPING_LIMIT_EXPLANATION`,
                `Capping limit explanation`,
                capping_limit_explanation,
                "String",
                false,
                true
            );
        }
    }
}
