/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
head_and_neck_score();

/**
 * Performs the head and neck score calculation for the specified models
 */
function head_and_neck_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `head and neck`;

    let occupants = ["DRIVER", "FRONT_PASSENGER", "REAR_DRIVER_SIDE"];
    for (let m of models) {
        /* Later we create a REPORTER variable to display an explanatory message if any capping
         * limit exceeded */
        let capping_limit_explanation = "";
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Head score and modifiers */

            /* Shared */
            let head_three_ms_exc_score = get_variable_value(
                status,
                `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_SCORE`,
                "float"
            );
            let head_tms_capping_limit = get_variable_value(
                status,
                `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_CAPPING_LIMIT`
            );
            let unstable_ab_contact_mod = get_variable_value(status, `${m}_${occ}_HEAD_AIRBAG_CONTACT_MODIFIER`, "int");
            let inc_ab_mod = get_variable_value(status, `${m}_${occ}_HEAD_INCORRECT_AIRBAG_DEPLOYMENT_MODIFIER`, "int");

            /* Driver and Front Passenger*/
            let head_hic_score;
            let head_hic_capping_limit;
            if (occ == "DRIVER" || occ == "FRONT_PASSENGER") {
                head_hic_score = get_variable_value(status, `${m}_${occ}_HEAD_HIC_SCORE`, "float");
                head_hic_capping_limit = get_variable_value(status, `${m}_${occ}_HEAD_HIC_CAPPING_LIMIT`);
            }
            /*  let ab_con_mod = get_variable_value(status, `${m}_${occ}_HEAD_AIRBAG_CONTACT_MODIFIER`, "int"); */

            /*Driver */
            let steering_column_intrusion_x_score;
            let steering_column_intrusion_z_score;
            if (occ == "DRIVER") {
                steering_column_intrusion_x_score = get_variable_value(
                    status,
                    `${m}_STRUCTURE_STEERING_COLUMN_FORE_AFT_INTRUSION_SCORE`,
                    "float"
                );
                steering_column_intrusion_z_score = get_variable_value(
                    status,
                    `${m}_STRUCTURE_STEERING_COLUMN_VERTICAL_INTRUSION_SCORE`,
                    "float"
                );
            }

            /* Neck score */
            let neck_axial_tension_score;
            let neck_shear_score;
            let neck_extension_score;
            let neck_axial_capping_limit;
            let neck_shear_capping_limit;
            let neck_extension_capping_limit;

            if (occ == "REAR_DRIVER_SIDE") {
                neck_axial_tension_score = get_variable_value(
                    status,
                    `${m}_${occ}_NECK_AXIAL_REAR_PASSENGER_SCORE`,
                    "float"
                );
                neck_shear_score = get_variable_value(status, `${m}_${occ}_NECK_SHEAR_REAR_PASSENGER_SCORE`, "float");
                neck_extension_score = get_variable_value(
                    status,
                    `${m}_${occ}_NECK_EXTENSION_REAR_PASSENGER_SCORE`,
                    "float"
                );
            } else {
                neck_axial_tension_score = get_variable_value(status, `${m}_${occ}_NECK_AXIAL_SCORE`, "float");
                neck_shear_score = get_variable_value(status, `${m}_${occ}_NECK_SHEAR_SCORE`, "float");
                neck_extension_score = get_variable_value(status, `${m}_${occ}_NECK_EXTENSION_SCORE`, "float");
                neck_axial_capping_limit = get_variable_value(status, `${m}_${occ}_NECK_AXIAL_CAPPING_LIMIT`);
                neck_shear_capping_limit = get_variable_value(status, `${m}_${occ}_NECK_SHEAR_CAPPING_LIMIT`);
                neck_extension_capping_limit = get_variable_value(status, `${m}_${occ}_NECK_EXTENSION_CAPPING_LIMIT`);
            }

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let head_score = 0;
            let neck_score = 0;
            //let head_and_neck_score = 0;
            /* Capping limits start as exceeded and will remain so if any variables were missing or invalid */
            let head_capping_limit = "*";
            let neck_capping_limit = "*";
            // let head_neck_capping_limit = "*";

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                /* Head score is sum of score with modifiers.
                 * For the driver, steering wheel airbag must be present or score remains zero. */

                if (occ == "DRIVER" || occ == "FRONT_PASSENGER") {
                    head_score =
                        Math.min(head_hic_score, head_three_ms_exc_score) + unstable_ab_contact_mod + inc_ab_mod;

                    if (occ == "DRIVER") {
                        /* For the driver, also add the steering column intrusion modifier */
                        let steering_column_intrusion_min_score =
                            steering_column_intrusion_x_score + steering_column_intrusion_z_score;
                        head_score += steering_column_intrusion_min_score;
                    }
                } else if (occ == "REAR_DRIVER_SIDE") {
                    head_score = head_three_ms_exc_score + unstable_ab_contact_mod + inc_ab_mod;
                }
                /* Neck score is minimum of axial, shear, and bending components */
                if (occ == "DRIVER" || occ == "FRONT_PASSENGER") {
                    neck_score = Math.min(neck_axial_tension_score, neck_shear_score, neck_extension_score);
                } else if (occ == "REAR_DRIVER_SIDE") {
                    neck_score = neck_axial_tension_score + neck_shear_score + neck_extension_score;
                }
                /* Bound the score between upper and lower limits */

                head_score = Math.max(Math.min(head_score, 4.0), 0.0);
                neck_score = Math.max(Math.min(neck_score, 4.0), 0.0);

                LogPrint(`${m} ${occ} head score = ${head_score}`);
                LogPrint(`${m} ${occ} neck score = ${neck_score}`);

                /* Check capping limits. If any individual limits are exceeded, an asterisk is
                 * displayed for all parent body regions. */

                // head capping limit calculation
                //
                if (
                    (occ == "DRIVER" || occ == "FRONT_PASSENGER") &&
                    return_capping_limit([head_hic_capping_limit, head_tms_capping_limit]) == ""
                ) {
                    head_capping_limit = "";
                } else if (occ == "REAR_DRIVER_SIDE" && return_capping_limit([head_tms_capping_limit]) == "") {
                    head_capping_limit = "";
                }
                // neck capping limit calculation
                // (no capping limit for the rear passenger)
                if (
                    (occ == "DRIVER" || occ == "FRONT_PASSENGER") &&
                    return_capping_limit([
                        neck_axial_capping_limit,
                        neck_shear_capping_limit,
                        neck_extension_capping_limit
                    ]) == ""
                ) {
                    neck_capping_limit = "";
                } else {
                    capping_limit_explanation = `*Capping limit exceeded`;
                }
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            /* Overall scores */
            new Variable(
                templ,
                `${m}_${occ}_HEAD_FINAL_SCORE`,
                "Final head score",
                head_score.toString(),
                "String",
                false,
                true
            );
            new Variable(
                templ,
                `${m}_${occ}_NECK_FINAL_SCORE`,
                "Final neck score",
                neck_score.toString(),
                "String",
                false,
                true
            );
            /* Capping limits */
            new Variable(
                templ,
                `${m}_${occ}_HEAD_CAPPING_LIMIT`,
                "Head capping limit (*asterisk if limit exceeded; empty string otherwise)",
                head_capping_limit,
                "String",
                false,
                true
            );
            new Variable(
                templ,
                `${m}_${occ}_NECK_CAPPING_LIMIT`,
                "Neck capping limit (*asterisk if limit exceeded; empty string otherwise)",
                neck_capping_limit,
                "String",
                false,
                true
            );
        }
        new Variable(
            templ,
            `${m}_HEAD_NECK_CAPPING_LIMIT_EXPLANATION`,
            `Capping limit explanation`,
            capping_limit_explanation,
            "String",
            false,
            true
        );
    }
}
