/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
chest_score();

/**
 * Performs the chest  score calculation for the specified models
 */
function chest_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `chest`;

    let occupants = ["DRIVER", "FRONT_PASSENGER", "REAR_DRIVER_SIDE"];
    for (let m of models) {
        /* Later we create a REPORTER variable to display an explanatory message if any capping
         * limit exceeded */
        let capping_limit_explanation = "";
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Chest score and modifiers */

            /* Driver */
            let steering_wheel_contact_mod;

            /* Front passenger */
            let chest_comp_score;
            let chest_vc_score;
            let chest_comp_capping_limit;
            let chest_vc_capping_limit;

            /* Shared */
            let belt_load_mod = get_variable_value(
                status,
                `${m}_${occ}_SHOULDER_BELT_B3_SHOULDER_BELT_FORCE_SCORE`,
                "int"
            );

            if (occ == "DRIVER") {
                steering_wheel_contact_mod = get_variable_value(
                    status,
                    `${m}_${occ}_CHEST_STEERING_WHEEL_CONTACT_MODIFIER`,
                    "int"
                );
            }

            if (occ == "DRIVER" || occ == "FRONT_PASSENGER") {
                chest_comp_score = get_variable_value(status, `${m}_${occ}_CHEST_COMPRESSION_SCORE`, "float");
                chest_vc_score = get_variable_value(status, `${m}_${occ}_CHEST_VISCOUS_CRITERION_SCORE`, "float");
                chest_comp_capping_limit = get_variable_value(status, `${m}_${occ}_CHEST_COMPRESSION_CAPPING_LIMIT`);
                chest_vc_capping_limit = get_variable_value(
                    status,
                    `${m}_${occ}_CHEST_VISCOUS_CRITERION_CAPPING_LIMIT`
                );
            } else if (occ == "REAR_DRIVER_SIDE") {
                chest_comp_score = get_variable_value(
                    status,
                    `${m}_${occ}_CHEST_COMPRESSION_REAR_PASSENGER_SCORE`,
                    "float"
                );
                chest_vc_score = get_variable_value(status, `${m}_${occ}_CHEST_VISCOUS_CRITERION_SCORE`, "float");
                chest_comp_capping_limit = get_variable_value(
                    status,
                    `${m}_${occ}_CHEST_COMPRESSION_REAR_PASSENGER_CAPPING_LIMIT`
                );
                chest_vc_capping_limit = get_variable_value(
                    status,
                    `${m}_${occ}_CHEST_VISCOUS_CRITERION_CAPPING_LIMIT`
                );
            }

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let chest_score_before_mods = 0;
            let chest_score = 0;
            /* Capping limits start as exceeded and will remain so if any variables were missing or invalid */
            let chest_capping_limit = "*";

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                /* Chest score is minimum of compression and viscous criterion scores, summed with modifiers
                 * (which are different for different occupants) */
                chest_score_before_mods = Math.min(chest_comp_score, chest_vc_score);

                if (occ == "DRIVER") {
                    chest_score = Math.max(0, chest_score_before_mods + steering_wheel_contact_mod + belt_load_mod);
                } else if (occ == "FRONT_PASSENGER" || occ == "REAR_DRIVER_SIDE") {
                    chest_score = Math.max(0, chest_score_before_mods + belt_load_mod);
                }

                /* Check capping limits. If any individual limits are exceeded, an asterisk is
                 * displayed for all parent body regions. */
                if (return_capping_limit([chest_comp_capping_limit, chest_vc_capping_limit]) == "") {
                    chest_capping_limit = "";
                } else {
                    capping_limit_explanation = `*Capping limit exceeded`;
                }

                LogPrint(`${m} ${occ} chest score = ${chest_score}`);
                LogPrint(`${m} ${occ} ${body_region_label} score = ${chest_score}`);
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            /* Only write some variables for driver */

            new Variable(
                templ,
                `${m}_${occ}_CHEST_FINAL_SCORE`,
                "Final chest score",
                chest_score.toString(),
                "String",
                false,
                true
            );
            new Variable(
                templ,
                `${m}_${occ}_CHEST_CAPPING_LIMIT`,
                `Chest capping limit`,
                chest_capping_limit,
                "String",
                false,
                true
            );
        }
        new Variable(
            templ,
            `${m}_CHEST_CAPPING_LIMIT_EXPLANATION`,
            `Capping limit explanation`,
            capping_limit_explanation,
            "String",
            false,
            true
        );
    }
}
