/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
pelvis_score();

/**
 * Performs the pelvis score calculation for the specified models
 */
function pelvis_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `pelvis`;

    /* NOTE:
     * The variables, scoring, and weighting factors are
     * same for driver and front passenger; for JNCAP-MDB Protocol.
     */

    /* Weighting factor */
    let lumbar_weighting_factor = 0.5;

    new Variable(
        templ,
        "LUMBAR_WEIGHTING_FACTOR",
        "Lumbar weighting factor",
        lumbar_weighting_factor.toString(),
        "String",
        false,
        true
    );

    let occupants = ["DRIVER", "FRONT_PASSENGER"];

    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Shared */

            let pubic_sym_force_score = get_variable_value(status, `${m}_${occ}_PELVIS_FORCE_SCORE`, "float");

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let pelvis_score_weighted = 0;
            let pelvis_score = 0;

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                /* Weighted score */
                pelvis_score_weighted = pubic_sym_force_score * lumbar_weighting_factor;

                pelvis_score = pelvis_score_weighted;

                LogPrint(`${m} ${occ} ${body_region_label} score = ${pelvis_score}`);
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            /*Sending values to reporter*/

            new Variable(
                templ,
                `${m}_${occ}_PELVIS_SCORE_WEIGHTED`,
                `Weighted ${body_region_label} score`,
                pelvis_score_weighted.toString(),
                "String",
                false,
                true
            );

            new Variable(
                templ,
                `${m}_${occ}_PELVIS_FINAL_SCORE`,
                `Final ${body_region_label} score`,
                pelvis_score.toString(),
                "String",
                false,
                true
            );
        }
    }
}
