/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
head_score();

/**
 * Performs the head score calculation for the specified models
 */
function head_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `head`;

    /* Weighting factor */
    let head_weighting_factor = 1.0;

    new Variable(
        templ,
        "HEAD_WEIGHTING_FACTOR",
        "Head weighting factor",
        head_weighting_factor.toString(),
        "String",
        false,
        true
    );

    let occupants = ["DRIVER", "FRONT_PASSENGER"];

    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Reading values from reporter*/
            let head_hic15_score = get_variable_value(status, `${m}_${occ}_HEAD_HIC15_SCORE`, "float");

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let head_hic15_score_weighted = 0;
            let head_score = 0;

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                head_hic15_score_weighted = head_hic15_score * head_weighting_factor;

                head_score = head_hic15_score_weighted;

                /* Bound the score between upper and lower limits */
                head_score = Math.min(head_score, 4.0);

                LogPrint(`${m} ${occ} head score = ${head_score}`);
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            /* Weighted score */
            new Variable(
                templ,
                `${m}_${occ}_HEAD_HIC15_SCORE_WEIGHTED`,
                "Head score weighted",
                head_hic15_score_weighted.toString(),
                "String",
                false,
                true
            );

            /* Overall scores */
            new Variable(
                templ,
                `${m}_${occ}_HEAD_FINAL_SCORE`,
                "Final head score",
                head_score.toString(),
                "String",
                false,
                true
            );
        }
    }
}
