/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
abdomen_score();

/**
 * Performs the abdomen score calculation for the specified models
 */
function abdomen_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `abdomen`;

    /* Weighting factors */
    let abdomen_weighting_factor = 0.5;

    new Variable(
        templ,
        "ABDOMEN_WEIGHTING_FACTOR",
        "Abdomen weighting factor",
        abdomen_weighting_factor.toString(),
        "String",
        false,
        true
    );

    let occupants = ["DRIVER", "FRONT_PASSENGER"];

    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Abdomen score and modifiers */
            let abdomen_comp_top_max_score;
            let abdomen_comp_bottom_max_score;

            abdomen_comp_top_max_score = get_variable_value(
                status,
                `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_01_SCORE`,
                "float"
            );
            abdomen_comp_bottom_max_score = get_variable_value(
                status,
                `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_02_SCORE`,
                "float"
            );

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let abdomen_comp_score_max_01_weighted = 0;
            let abdomen_comp_score_max_02_weighted = 0;
            let abdomen_score = 0;

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                /* Weighted scores */
                abdomen_comp_score_max_01_weighted = abdomen_comp_top_max_score * abdomen_weighting_factor;
                abdomen_comp_score_max_02_weighted = abdomen_comp_bottom_max_score * abdomen_weighting_factor;

                abdomen_score = Math.min(abdomen_comp_score_max_01_weighted, abdomen_comp_score_max_02_weighted);

                LogPrint(`${m} ${occ} abdomen score = ${abdomen_score}`);
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            new Variable(
                templ,
                `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_01_SCORE_WEIGHTED`,
                "Weighted abdomen compression score (top)",
                abdomen_comp_score_max_01_weighted.toString(),
                "String",
                false,
                true
            );

            new Variable(
                templ,
                `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_02_SCORE_WEIGHTED`,
                "Weighted abdomen compression score (bottom)",
                abdomen_comp_score_max_02_weighted.toString(),
                "String",
                false,
                true
            );

            new Variable(
                templ,
                `${m}_${occ}_ABDOMEN_FINAL_SCORE`,
                "Final abdomen score",
                abdomen_score.toString(),
                "String",
                false,
                true
            );
        }
    }
}
