/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
draw_occupant_images();

/**
 * Draw occupant body region scoring indicator images for the specified models
 */
function draw_occupant_images() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let output_dir = get_expanded_variable_value(templ, `OUTPUT_DIR`);
    if (!output_dir) {
        LogError(`Could not find OUTPUT_DIR variable for writing occupant image files.`);
        return;
    } else if (!File.IsDirectory(output_dir)) {
        LogError(`OUTPUT_DIR is not a valid directory: ${output_dir}`);
        return;
    }

    let occupants = ["DRIVER", "FRONT_PASSENGER"];
    for (let m of models) {
        for (let occ of occupants) {
            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            let level = get_variable_value(status, `${m}_${occ}_EVALUATION_LEVEL`, "float");

            if (!status.success) {
                warn_about_missing_or_invalid_variables(status, `${m} evaluation level image`);
            }

            let img = draw_JNCAP_evaluation_level_image(level);

            LogPrint(`evaluation image is saved to this name ${output_dir}/${m}_${occ}_level.png`);
            img.Save(`${output_dir}/${m}_${occ}_level.png`, Image.PNG);
        }
    }
}
