/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
thigh_and_hip();

/**
 * Performs the thigh and hip score calculation for the specified models
 */
function thigh_and_hip() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `thigh and hip`;

    let occupants = ["DRIVER", "FRONT_PASSENGER"];
    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            let left_kth_rating = get_variable_value(status, `${m}_${occ}_LEFT_FEMUR_IMPULSE_VS_COMPRESSION_RATING`);
            let right_kth_rating = get_variable_value(status, `${m}_${occ}_RIGHT_FEMUR_IMPULSE_VS_COMPRESSION_RATING`);

            let thigh_and_hip_rating = "Not Computed";
            if (status.success) {
                thigh_and_hip_rating = return_worst_IIHS_rating([left_kth_rating, right_kth_rating]);

                LogPrint(`${m} ${occ} thigh and hip rating = ${thigh_and_hip_rating}`);
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            let thigh_and_hip_rating_var = new Variable(
                templ,
                `${m}_${occ}_THIGH_AND_HIP_RATING`,
                "Final chest score",
                thigh_and_hip_rating,
                "String",
                false,
                true
            );
        }
    }
}
