/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
draw_occupant_images();

/**
 * Draw occupant body region scoring indicator images for the specified models
 */
function draw_occupant_images() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let output_dir = get_expanded_variable_value(templ, `OUTPUT_DIR`);
    let occupants;
    /* Create a status object to track whether REPORTER Variables are all present and valid.
     * <success> is initially true but will be set to false if anything missing or invalid. */
    let status = { success: true, missing: [], invalid: [] };
    if (!output_dir) {
        LogError(`Could not find OUTPUT_DIR variable for writing occupant image files.`);
        return;
    } else if (!File.IsDirectory(output_dir)) {
        LogError(`OUTPUT_DIR is not a valid directory: ${output_dir}`);
        return;
    }
    let crash_test_type = get_variable_value(status, `TEMPLATE_CRASH_TEST`, "string");

    if (!status.success) {
        LogWarning(`Variable "TEMPLATE_CRASH_TEST" is missing for draw image `);
        return;
    }

    if (crash_test_type == "ODB") {
        occupants = ["DRIVER"];
    } else if (crash_test_type == "SOB") {
        occupants = ["DRIVER", "FRONT_PASSENGER"];
    } else if (crash_test_type == "MDB") {
        occupants = ["DRIVER", "REAR_DRIVER_SIDE"];
    } else {
        LogWarning(`Variable "TEMPLATE_CRASH_TEST" value "${crash_test_type}" is invalid for draw image`);
        return;
    }

    for (let m of models) {
        for (let occ of occupants) {
            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Create new image */
            /** @type {Image} */
            let img;

            if (crash_test_type == "MDB") {
                img = new Image(300, 342);
            } else {
                img = new Image(190, 342);
            }

            img.lineWidth = 1;
            img.lineColour = "black";

            var score;

            if (crash_test_type == "MDB") {
                score = get_variable_value(status, `${m}_${occ}_HEAD_AND_NECK_FINAL_RATING`, "string");

                // head and neck
                draw_side_view_head(img, get_fill_colour_IIHS(score));
                draw_side_view_neck(img, get_fill_colour_IIHS(score));
            } else {
                //head
                score = get_variable_value(status, `${m}_${occ}_HEAD_FINAL_RATING`, "string");
                draw_front_view_head(img, get_fill_colour_IIHS(score));

                //neck
                score = get_variable_value(status, `${m}_${occ}_NECK_FINAL_RATING`, "string");
                draw_front_view_neck(img, get_fill_colour_IIHS(score));
            }

            if (crash_test_type == "MDB") {
                score = get_variable_value(status, `${m}_${occ}_TORSO_FINAL_RATING`, "string");

                // chest and abdomen
                draw_side_view_chest(img, get_fill_colour_IIHS(score));
                draw_side_view_abdomen(img, get_fill_colour_IIHS(score));
            } else {
                //chest
                score;
                draw_front_view_chest(img, get_fill_colour_IIHS(score));

                //abdomen - not coloured in
                draw_front_view_abdomen(img, get_fill_colour_IIHS(null)); // Not coloured in
            }

            // pelvis
            if (crash_test_type == "MDB") {
                score = get_variable_value(status, `${m}_${occ}_PELVIS_FINAL_RATING`, "string");
                draw_side_view_pelvis(img, get_fill_colour_IIHS(score));
            }

            // right femur
            if (crash_test_type == "ODB") {
                // ODB - worst out of femur compression, femur compression exceedence and knee displacement
                var scores = new Array(3);
                scores[0] = get_variable_value(status, `${m}_${occ}_RIGHT_FEMUR_COMPRESSION_RATING`, "string");
                scores[1] = get_variable_value(
                    status,
                    `${m}_${occ}_RIGHT_FEMUR_COMPRESSION_EXCEEDENCE_RATING`,
                    "string"
                );
                scores[2] = get_variable_value(status, `${m}_${occ}_RIGHT_KNEE_COMPRESSION_RATING`, "string");
                score = return_worst_IIHS_rating(scores);
                draw_front_view_right_femur(img, get_fill_colour_IIHS(score));
            } else if (crash_test_type == "SOB") {
                score = get_variable_value(status, `${m}_${occ}_RIGHT_FEMUR_IMPULSE_VS_COMPRESSION_RATING`, "string");
                draw_front_view_right_femur(img, get_fill_colour_IIHS(score));
            }

            // left femur
            if (crash_test_type == "ODB") {
                // ODB - worst out of femur compression, femur compression exceedence and knee displacement
                var scores = new Array(3);
                scores[0] = get_variable_value(status, `${m}_${occ}_LEFT_FEMUR_COMPRESSION_RATING`, "string");
                scores[1] = get_variable_value(
                    status,
                    `${m}_${occ}_LEFT_FEMUR_COMPRESSION_EXCEEDENCE_RATING`,
                    "string"
                );
                scores[2] = get_variable_value(status, `${m}_${occ}_LEFT_KNEE_COMPRESSION_RATING`, "string");
                score = return_worst_IIHS_rating(scores);
                draw_front_view_left_femur(img, get_fill_colour_IIHS(score));
            } else if (crash_test_type == "SOB") {
                score = get_variable_value(status, `${m}_${occ}_LEFT_FEMUR_IMPULSE_VS_COMPRESSION_RATING`, "string");
                draw_front_view_left_femur(img, get_fill_colour_IIHS(score));
            }

            //right tibia
            // Right tibia - worst out of upper and lower tibia index, upper and lower tibia compression and knee displacement
            if (crash_test_type == "ODB" || crash_test_type == "SOB") {
                var scores = new Array(4);
                scores[0] = get_variable_value(
                    status,
                    `${m}_${occ}_RIGHT_TIBIA_COMPRESSION_LOWER_MAX_RATING`,
                    "string"
                );
                scores[1] = get_variable_value(
                    status,
                    `${m}_${occ}_RIGHT_TIBIA_COMPRESSION_UPPER_MAX_RATING`,
                    "string"
                );
                scores[2] = get_variable_value(status, `${m}_${occ}_RIGHT_TIBIA_INDEX_LOWER_MAX_RATING`, "string");
                scores[3] = get_variable_value(status, `${m}_${occ}_RIGHT_TIBIA_INDEX_UPPER_MAX_RATING`, "string");
                if (crash_test_type == "S0B")
                    scores.push(get_variable_value(status, `${m}_${occ}_RIGHT_KNEE_COMPRESSION_RATING`, "string"));
                score = return_worst_IIHS_rating(scores);
                draw_front_view_right_tibia(img, get_fill_colour_IIHS(score));

                // left tibia
                // Left tibia - worst out of upper and lower tibia index, upper and lower tibia compression and knee displacement
                var scores = new Array(4);
                scores[0] = get_variable_value(status, `${m}_${occ}_LEFT_TIBIA_COMPRESSION_LOWER_MAX_RATING`, "string");
                scores[1] = get_variable_value(status, `${m}_${occ}_LEFT_TIBIA_COMPRESSION_UPPER_MAX_RATING`, "string");
                scores[2] = get_variable_value(status, `${m}_${occ}_LEFT_TIBIA_INDEX_LOWER_MAX_RATING`, "string");
                scores[3] = get_variable_value(status, `${m}_${occ}_LEFT_TIBIA_INDEX_UPPER_MAX_RATING`, "string");
                if (crash_test_type == "S0B")
                    scores.push(get_variable_value(status, `${m}_${occ}_LEFT_KNEE_COMPRESSION_RATING`, "string"));
                score = return_worst_IIHS_rating(scores);
                draw_front_view_left_tibia(img, get_fill_colour_IIHS(score));

                //right foot
                score = get_variable_value(status, `${m}_${occ}_RIGHT_FOOT_ACCELERATION_RATING`, "string");
                draw_front_view_right_foot(img, get_fill_colour_IIHS(score));

                //left foot
                score = get_variable_value(status, `${m}_${occ}_LEFT_FOOT_ACCELERATION_RATING`, "string");
                draw_front_view_left_foot(img, get_fill_colour_IIHS(score));

                //left arm
                draw_front_view_left_arm(img, occ); // Not coloured in; occupant dependent

                //right arm
                draw_front_view_right_arm(img, occ); // Not coloured in; occupant dependent
            }

            if (crash_test_type == "MDB") {
                if (occ == "DRIVER") {
                    draw_side_view_right_arm(img, get_fill_colour_EuroNCAP(null));
                } else {
                    draw_side_view_right_arm_occupant(img);
                }
                draw_side_view_right_leg(img, get_fill_colour_EuroNCAP(null));
            }

            if (occ == "DRIVER") {
                if (crash_test_type == "MDB") {
                    draw_side_view_steering_wheel(img, "#000000");
                } else {
                    draw_front_view_steering_wheel(img);
                }
            }

            if (crash_test_type == "ODB" || crash_test_type == "SOB") {
                draw_front_view_seatbelt(img, occ);
            }

            img.Save(`${output_dir}/${m}_${occ.toLowerCase()}_plot.png`, Image.PNG);
        }
    }
}
