/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
chest_score();

/**
 * Performs the chest score calculation for the specified models
 */
function chest_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `chest`;

    let occupants;

    let status = { success: true, missing: [], invalid: [] };

    let crash_test_type = get_variable_value(status, `TEMPLATE_CRASH_TEST`, "string");

    if (!status.success) {
        LogWarning(`Variable "TEMPLATE_CRASH_TEST" is missing for overall rating calculation`);
        return;
    }

    if (crash_test_type == "ODB") {
        occupants = ["DRIVER"];
    } else if (crash_test_type == "SOB") {
        occupants = ["DRIVER", "FRONT_PASSENGER"];
    } else {
        LogWarning(
            `Variable "TEMPLATE_CRASH_TEST" value "${crash_test_type}" is invalid for overall rating calculation`
        );
        return;
    }

    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */

            /* Shared */
            let variable_values = get_multiple_variable_values(
                status,
                [
                    `${m}_${occ}_CHEST_COMPRESSION_RATING`,
                    `${m}_${occ}_CHEST_COMPRESSION_RATE_RATING`,
                    `${m}_${occ}_CHEST_THREE_MS_EXCEEDENCE_RATING`,
                    `${m}_${occ}_CHEST_VISCOUS_CRITERION_RATING`
                ],
                "string",
                true
            );

            /* Final rating starts at poor and will remain so if any variables were missing or invalid */
            let chest_rating = "Not computed";

            if (status.success) {
                chest_rating = return_worst_IIHS_rating(Object.values(variable_values));

                LogPrint(`${m} ${occ} chest rating = ${chest_rating}`);
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }
            let chest_score_var = new Variable(
                templ,
                `${m}_${occ}_CHEST_FINAL_RATING`,
                "Final chest score",
                chest_rating,
                "String",
                false,
                true
            );
        }
    }
}
