/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
structural_rating();

/**
 * Performs the structural rating calculation for the specified models
 */
function structural_rating() {
    let templ = Template.GetCurrent();
    let models = get_model_list();

    let occupants = ["DRIVER", "PASSENGER"];
    for (let m of models) {
        let all_occupant_structural_rating = [];

        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} structural rating...`);
            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            let upper_structural_rating;
            let lower_structural_rating;

            let occupant_lower_structural_ratings = [];
            let occupant_upper_structural_ratings = [];

            let occupant_structural_rating;

            /** Upper and Lower hinge pilar scores are the maximum of the 3 individual scores*/
            let upper_hinge_pillar_1_score = get_variable_value(
                status,
                `${m}_${occ}_UPPER_HINGE_1_${occ}_UPPER_HINGE_1_ALL_INTRUSION_RESULTANT_FINAL_VALUE`,
                "float"
            );
            let upper_hinge_pillar_1_rating = get_variable_value(
                status,
                `${m}_${occ}_UPPER_HINGE_1_${occ}_UPPER_HINGE_1_ALL_INTRUSION_RESULTANT_FINAL_RATING`,
                "string"
            );
            let upper_hinge_pillar_2_score = get_variable_value(
                status,
                `${m}_${occ}_UPPER_HINGE_2_${occ}_UPPER_HINGE_2_ALL_INTRUSION_RESULTANT_FINAL_VALUE`,
                "string"
            );
            let upper_hinge_pillar_2_rating = get_variable_value(
                status,
                `${m}_${occ}_UPPER_HINGE_2_${occ}_UPPER_HINGE_2_ALL_INTRUSION_RESULTANT_FINAL_RATING`,
                "string"
            );
            let upper_hinge_pillar_3_score = get_variable_value(
                status,
                `${m}_${occ}_UPPER_HINGE_3_${occ}_UPPER_HINGE_3_ALL_INTRUSION_RESULTANT_FINAL_VALUE`,
                "float"
            );
            let upper_hinge_pillar_3_rating = get_variable_value(
                status,
                `${m}_${occ}_UPPER_HINGE_3_${occ}_UPPER_HINGE_3_ALL_INTRUSION_RESULTANT_FINAL_RATING`,
                "string"
            );
            let lower_hinge_pillar_1_score = get_variable_value(
                status,
                `${m}_${occ}_LOWER_HINGE_1_${occ}_LOWER_HINGE_1_ALL_INTRUSION_RESULTANT_FINAL_VALUE`,
                "float"
            );
            let lower_hinge_pillar_1_rating = get_variable_value(
                status,
                `${m}_${occ}_LOWER_HINGE_1_${occ}_LOWER_HINGE_1_ALL_INTRUSION_RESULTANT_FINAL_RATING`,
                "string"
            );
            let lower_hinge_pillar_2_score = get_variable_value(
                status,
                `${m}_${occ}_LOWER_HINGE_2_${occ}_LOWER_HINGE_2_ALL_INTRUSION_RESULTANT_FINAL_VALUE`,
                "float"
            );
            let lower_hinge_pillar_2_rating = get_variable_value(
                status,
                `${m}_${occ}_LOWER_HINGE_2_${occ}_LOWER_HINGE_2_ALL_INTRUSION_RESULTANT_FINAL_RATING`,
                "string"
            );
            let lower_hinge_pillar_3_score = get_variable_value(
                status,
                `${m}_${occ}_LOWER_HINGE_3_${occ}_LOWER_HINGE_3_ALL_INTRUSION_RESULTANT_FINAL_VALUE`,
                "float"
            );
            let lower_hinge_pillar_3_rating = get_variable_value(
                status,
                `${m}_${occ}_LOWER_HINGE_3_${occ}_LOWER_HINGE_3_ALL_INTRUSION_RESULTANT_FINAL_RATING`,
                "string"
            );
            let upper_hinge_piller_max_score;
            let lower_hinge_piller_max_score;
            let upper_hinge_piller_max_rating;
            let lower_hinge_piller_max_rating;

            upper_hinge_piller_max_score = Math.max(
                upper_hinge_pillar_1_score,
                upper_hinge_pillar_2_score,
                upper_hinge_pillar_3_score
            );

            if (upper_hinge_piller_max_score == upper_hinge_pillar_1_score) {
                upper_hinge_piller_max_rating = upper_hinge_pillar_1_rating;
            } else if (upper_hinge_piller_max_score == upper_hinge_pillar_2_score) {
                upper_hinge_piller_max_rating = upper_hinge_pillar_2_rating;
            } else if (upper_hinge_piller_max_score == upper_hinge_pillar_3_score) {
                upper_hinge_piller_max_rating = upper_hinge_pillar_3_rating;
            }

            lower_hinge_piller_max_score = Math.max(
                lower_hinge_pillar_1_score,
                lower_hinge_pillar_2_score,
                lower_hinge_pillar_3_score
            );

            if (lower_hinge_piller_max_score == lower_hinge_pillar_1_score) {
                lower_hinge_piller_max_rating = lower_hinge_pillar_1_rating;
            } else if (lower_hinge_piller_max_score == lower_hinge_pillar_2_score) {
                lower_hinge_piller_max_rating = lower_hinge_pillar_2_rating;
            } else lower_hinge_piller_max_score == lower_hinge_pillar_3_score;
            {
                lower_hinge_piller_max_rating = lower_hinge_pillar_3_rating;
            }

            /** Rocker panel score is the average of the 3 individual scores*/
            let rocker_panel_1 = get_variable_value(
                status,
                `${m}_STRUCTURE_${occ}_ROCKER_PANEL_1_LATERAL_INTRUSION_Y_FINAL_VALUE`,
                "float"
            );
            let rocker_panel_2 = get_variable_value(
                status,
                `${m}_STRUCTURE_${occ}_ROCKER_PANEL_2_LATERAL_INTRUSION_Y_FINAL_VALUE`,
                "float"
            );
            let rocker_panel_3 = get_variable_value(
                status,
                `${m}_STRUCTURE_${occ}_ROCKER_PANEL_3_LATERAL_INTRUSION_Y_FINAL_VALUE`,
                "float"
            );

            let rocker_panel_avg_score;
            let rocker_panel_avg_rating;
            rocker_panel_avg_score = (rocker_panel_1 + rocker_panel_2 + rocker_panel_3) / 3;
            if (rocker_panel_avg_score <= 5) {
                rocker_panel_avg_rating = "Good";
            } else if (rocker_panel_avg_score > 5 && rocker_panel_avg_score <= 10) {
                rocker_panel_avg_rating = "Acceptable";
            } else if (rocker_panel_avg_score > 10 && rocker_panel_avg_score <= 15) {
                rocker_panel_avg_rating == "Marginal";
            } else {
                rocker_panel_avg_rating = "Poor";
            }

            switch (occ) {
                case "DRIVER":
                    /**Calculate upper compartment ratings for Driver */

                    occupant_upper_structural_ratings[0] = get_variable_value(
                        status,
                        `${m}_STRUCTURE_STEERING_COLUMN_FORE_AFT_INTRUSION_RATING`,
                        "string"
                    );
                    occupant_upper_structural_ratings[1] = get_variable_value(
                        status,
                        `${m}_LEFT_INSTRUMENT_PANEL_LEFT_INSTRUMENT_PANEL_ALL_INTRUSION_RESULTANT_FINAL_RATING`,
                        "string"
                    );
                    occupant_upper_structural_ratings[2] = get_variable_value(
                        status,
                        `${m}_${occ}_UPPER_DASH_${occ}_UPPER_DASH_ALL_INTRUSION_RESULTANT_FINAL_RATING`,
                        "string"
                    );
                    occupant_upper_structural_ratings[3] = upper_hinge_piller_max_rating;

                    /**Calculate lower compartment ratings for Driver */

                    occupant_lower_structural_ratings[0] = get_variable_value(
                        status,
                        `${m}_BRAKE_PEDAL_BRAKE_PEDAL_ALL_INTRUSION_RESULTANT_FINAL_RATING`,
                        "string"
                    );
                    occupant_lower_structural_ratings[1] = get_variable_value(
                        status,
                        `${m}_PARKING_BRAKE_PARKING_BRAKE_ALL_INTRUSION_RESULTANT_FINAL_RATING`,
                        "string"
                    );
                    occupant_lower_structural_ratings[2] = get_variable_value(
                        status,
                        `${m}_${occ}_FOOTREST_${occ}_FOOTREST_ALL_INTRUSION_RESULTANT_FINAL_RATING`,
                        "string"
                    );
                    occupant_lower_structural_ratings[3] = get_variable_value(
                        status,
                        `${m}_${occ}_LEFT_TOEPAN_${occ}_LEFT_TOEPAN_ALL_INTRUSION_RESULTANT_FINAL_RATING`,
                        "string"
                    );
                    occupant_lower_structural_ratings[4] = lower_hinge_piller_max_rating;
                    occupant_lower_structural_ratings[5] = rocker_panel_avg_rating;

                    break;

                case "PASSENGER":
                    /**Calculate upper compartment ratings for Passeneger */

                    occupant_upper_structural_ratings[0] = get_variable_value(
                        status,
                        `${m}_${occ}_CENTRE_DASH_${occ}_CENTRE_DASH_ALL_INTRUSION_RESULTANT_FINAL_RATING`,
                        "string"
                    );
                    occupant_upper_structural_ratings[1] = get_variable_value(
                        status,
                        `${m}_${occ}_UPPER_DASH_${occ}_UPPER_DASH_ALL_INTRUSION_RESULTANT_FINAL_RATING`,
                        "string"
                    );
                    occupant_upper_structural_ratings[2] = get_variable_value(
                        status,
                        `${m}_${occ}_LEFT_LOWER_DASH_${occ}_LEFT_LOWER_DASH_ALL_INTRUSION_RESULTANT_FINAL_RATING`,
                        "string"
                    );
                    occupant_upper_structural_ratings[3] = get_variable_value(
                        status,
                        `${m}_${occ}_RIGHT_LOWER_DASH_${occ}_RIGHT_LOWER_DASH_ALL_INTRUSION_RESULTANT_FINAL_RATING`,
                        "string"
                    );
                    occupant_upper_structural_ratings[4] = upper_hinge_piller_max_rating;

                    /**Calculate lower compartment ratings for Passeneger */

                    occupant_lower_structural_ratings[0] = get_variable_value(
                        status,
                        `${m}_${occ}_RIGHT_TOEPAN_${occ}_RIGHT_TOEPAN_ALL_INTRUSION_RESULTANT_FINAL_RATING`,
                        "string"
                    );
                    occupant_lower_structural_ratings[1] = get_variable_value(
                        status,
                        `${m}_${occ}_CENTRE_TOEPAN_${occ}_CENTRE_TOEPAN_ALL_INTRUSION_RESULTANT_FINAL_RATING`,
                        "string"
                    );
                    occupant_lower_structural_ratings[2] = get_variable_value(
                        status,
                        `${m}_${occ}_LEFT_TOEPAN_${occ}_LEFT_TOEPAN_ALL_INTRUSION_RESULTANT_FINAL_RATING`,
                        "string"
                    );
                    occupant_lower_structural_ratings[3] = get_variable_value(
                        status,
                        `${m}_${occ}_FOOTREST_${occ}_FOOTREST_ALL_INTRUSION_RESULTANT_FINAL_RATING`,
                        "string"
                    );
                    occupant_lower_structural_ratings[4] = lower_hinge_piller_max_rating;

                    occupant_lower_structural_ratings[5] = rocker_panel_avg_rating;

                    break;

                default:
                    break;
            }

            /** Create variables to Count number of Poor, Marginal, Acceptable, Good*/

            let upper_ratings_count = { poor: 0, marginal: 0, acceptable: 0, good: 0 };
            let lower_ratings_count = { poor: 0, marginal: 0, acceptable: 0, good: 0 };

            if (status.success) {
                /* Count number of Poor, Marginal, Acceptable, Good and get overall rating */
                upper_ratings_count = count_IIHS_ratings(occupant_upper_structural_ratings);
                lower_ratings_count = count_IIHS_ratings(occupant_lower_structural_ratings);

                upper_structural_rating = get_overall_IIHS_rating_from_count(upper_ratings_count);
                lower_structural_rating = get_overall_IIHS_rating_from_count(lower_ratings_count);
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} calculation`);
            }

            // Rating cannot be more than one rating level better than the worst rating.

            var downgrade_from = upper_structural_rating;

            let clamp = clamp_IIHS_strucural_rating(upper_structural_rating, upper_ratings_count);

            var downgraded = clamp.downgraded;
            var worst_rating = clamp.worst_rating;
            var downgrade_to = clamp.downgrade_to;

            upper_structural_rating = downgrade_to;

            // Set text to explain how the rating was calculated - explain about any downgrades

            var text = "";

            if (!downgraded) text += "\n\n";

            text +=
                "The rating for the Upper Compartment is taken as the rating with the most measures. Where there is a tie, the lower rating is used.";

            if (downgraded)
                text +=
                    "\n\nThe rating cannot be more than one rating level better than the worst measurement (" +
                    worst_rating +
                    "), so the overall rating was downgraded from " +
                    downgrade_from +
                    " to " +
                    downgrade_to +
                    ".";

            var variable = new Variable(
                templ,
                `STRUCTURAL_${occ}_UPPER_TEXT`,
                "Text to explain how upper compartment rating was calculated",
                text,
                "General"
            );

            downgrade_from = lower_structural_rating;

            clamp = clamp_IIHS_strucural_rating(lower_structural_rating, lower_ratings_count);

            downgraded = clamp.downgraded;
            worst_rating = clamp.worst_rating;
            downgrade_to = clamp.downgrade_to;

            lower_structural_rating = downgrade_to;

            // Set text to explain how the rating was calculated - explain about any downgrades

            text = "";

            if (!downgraded) text += "\n\n";

            text +=
                "The rating for the Lower Compartment is taken as the rating with the most measures. Where there is a tie, the lower rating is used.";

            if (downgraded)
                text +=
                    "\n\nThe rating cannot be more than one rating level better than the worst measurement (" +
                    worst_rating +
                    "), so the overall rating was downgraded from " +
                    downgrade_from +
                    " to " +
                    downgrade_to +
                    ".";

            var variable = new Variable(
                templ,
                `STRUCTURAL_${occ}_LOWER_TEXT`,
                `Text to explain how lower compartment rating was calculated`,
                text,
                "General"
            );

            // Overall structure rating is lower of upper and lower compartment rating

            occupant_structural_rating = return_worst_IIHS_rating([upper_structural_rating, lower_structural_rating]);

            let structural_rating_var = new Variable(
                templ,
                `${m}_${occ}_STRUCTURAL_RATING`,
                "The occupant structural rating which accounts for subjective downgrades",
                occupant_structural_rating,
                "String",
                false,
                true
            );

            /* Store the structural rating for each occupant to calculate the overall structural rating */

            all_occupant_structural_rating.push(occupant_structural_rating);

            // Variables

            let lower_hinge_score_var = new Variable(
                templ,
                `${m}_${occ}_LOWER_HINGE_MAX_RESULTANT_FINAL_VALUE`,
                "Maximum of the 3 lower hinge values",
                lower_hinge_piller_max_score.toString(),
                "String",
                false,
                true
            );

            let lower_hinge_rating_var = new Variable(
                templ,
                `${m}_${occ}_LOWER_HINGE_MAX_RATING`,
                "Rating for the maximum of the 3 lower hinge values",
                lower_hinge_piller_max_rating,
                "string",
                false,
                true
            );

            let upper_hinge_score_var = new Variable(
                templ,
                `${m}_${occ}_UPPER_HINGE_MAX_RESULTANT_FINAL_VALUE`,
                "Maximum of the 3 upper hinge values",
                upper_hinge_piller_max_score.toString(),
                "String",
                false,
                true
            );

            let upper_hinge_rating_var = new Variable(
                templ,
                `${m}_${occ}_UPPER_HINGE_MAX_RATING`,
                "Rating for the maximum of the 3 lower hinge values",
                upper_hinge_piller_max_rating,
                "String",
                false,
                true
            );

            let rocker_hinge_score_var = new Variable(
                templ,
                `${m}_STRUCTURE_${occ}_ROCKER_PANEL_AVERAGE_VALUE`,
                "Average of the 3 rocker panel values",
                rocker_panel_avg_score.toString(),
                "String",
                false,
                true
            );

            let rocker_hinge_rating_var = new Variable(
                templ,
                `${m}_STRUCTURE_${occ}_ROCKER_PANEL_AVERAGE_RATING`,
                "Rating of the average of the 3 rocker panel values",
                rocker_panel_avg_rating,
                "String",
                false,
                true
            );

            let upper_structural_rating_var = new Variable(
                templ,
                `${m}_${occ}_UPPER_STRUCTURAL_RATING`,
                "The upper structural rating",
                upper_structural_rating,
                "String",
                false,
                true
            );
            let lower_structural_rating_var = new Variable(
                templ,
                `${m}_${occ}_LOWER_STRUCTURAL_RATING`,
                "The lower structural rating",
                lower_structural_rating,
                "String",
                false,
                true
            );
        }

        /* Overall structural rating */

        let overall_structural_rating = return_worst_IIHS_rating(all_occupant_structural_rating);

        // Check for subjective downgrade

        let status = { success: true, missing: [], invalid: [] };

        var subjective_downgrade_level = get_variable_value(status, `${m}_STRUCTURAL_DOWNGRADE_DEMERIT`); //make sure name is correct

        if (status.success && subjective_downgrade_level > 0) {
            overall_structural_rating = downgrade_IIHS_rating(overall_structural_rating, subjective_downgrade_level);
        }

        /** HG 15th Jan 2025 - A 2024 addition:
         * If a significant fuel leak or compromise of the high-voltage system occurs,
         * both the structural and overall ratings may be downgraded to poor */
        status = { success: true, missing: [], invalid: [] };
        var fuel_voltage_downgrade = get_variable_value(status, `${m}_FUEL_VOLTAGE_DOWNGRADE_DEMERIT`);
        if (status.success && fuel_voltage_downgrade == "Poor") {
            overall_structural_rating = "Poor";
        }

        new Variable(
            templ,
            `${m}_OVERALL_STRUCTURAL_RATING`,
            "The overall structural rating based on the Driver and Passenger",
            overall_structural_rating,
            "String",
            false,
            true
        );
    }
}
