/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
restraint_rating();

/**
 * Performs the chest score calculation for the specified models
 */
function restraint_rating() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let occupants = ["DRIVER", "PASSENGER"];

    let Acceptable = 2;
    let Marginal = 4;
    let Poor = 6;

    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} restraint rating...`);
            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };
            let total_demerits = 0;
            let restraint_rating;
            switch (occ) {
                case "DRIVER":
                    var driver_demerits = new Array(10);

                    driver_demerits[0] = get_variable_value(
                        status,
                        `${m}_RESTRAINT_${occ}_FRONTAL_AIRBAG_INTERACTION_DEMERIT`,
                        "float"
                    );
                    driver_demerits[1] = get_variable_value(
                        status,
                        `${m}_RESTRAINT_${occ}_HEAD_STEERING_WHEEL_DEMERIT`,
                        "float"
                    );
                    driver_demerits[2] = get_variable_value(
                        status,
                        `${m}_RESTRAINT_${occ}_HEAD_CONTACT_DEMERIT`,
                        "float"
                    );
                    driver_demerits[3] = get_variable_value(
                        status,
                        `${m}_RESTRAINT_${occ}_SIDE_AIRBAG_DEPLOYMENT_DEMERIT`,
                        "float"
                    );
                    driver_demerits[4] = get_variable_value(
                        status,
                        `${m}_RESTRAINT_${occ}_HEAD_LATERAL_MOVEMENT_DEMERIT`,
                        "float"
                    );
                    driver_demerits[5] = get_variable_value(
                        status,
                        `${m}_RESTRAINT_${occ}_CHEST_VERTICAL_STEERING_WHEEL_DEMERIT`,
                        "float"
                    );
                    driver_demerits[6] = get_variable_value(
                        status,
                        `${m}_RESTRAINT_${occ}_CHEST_LATERAL_STEERING_WHEEL_DEMERIT`,
                        "float"
                    );
                    driver_demerits[7] = get_variable_value(
                        status,
                        `${m}_RESTRAINT_${occ}_OCCUPANT_EXCURSION_DEMERIT`,
                        "float"
                    );
                    driver_demerits[8] = get_variable_value(
                        status,
                        `${m}_RESTRAINT_${occ}_OCCUPANT_BURN_RISK_DEMERIT`,
                        "float"
                    );
                    driver_demerits[9] = get_variable_value(
                        status,
                        `${m}_RESTRAINT_${occ}_SEAT_INSTABILITY_DEMERIT`,
                        "float"
                    );

                    //Looking for the varibles that will automatically downgarde the score to POOR
                    var driver_auto_poor = new Array(3);
                    driver_auto_poor[0] = get_variable_value(
                        status,
                        `${m}_RESTRAINT_${occ}_LATE_AIRBAG_DEPLOYMENT_DEMERIT`,
                        "string"
                    );
                    driver_auto_poor[1] = get_variable_value(
                        status,
                        `${m}_RESTRAINT_${occ}_SEAT_ATTACHMENT_DEMERIT`,
                        "string"
                    );
                    driver_auto_poor[2] = get_variable_value(
                        status,
                        `${m}_RESTRAINT_${occ}_VEHICLE_DOOR_DEMERIT`,
                        "string"
                    );

                    break;
                case "PASSENGER":
                    var passenger_demerits = new Array(6);
                    passenger_demerits[0] = get_variable_value(
                        status,
                        `${m}_RESTRAINT_${occ}_FRONTAL_AIRBAG_INTERACTION_DEMERIT`,
                        "float"
                    );
                    passenger_demerits[1] = get_variable_value(
                        status,
                        `${m}_RESTRAINT_${occ}_HEAD_CONTACT_DEMERIT`,
                        "float"
                    );
                    passenger_demerits[2] = get_variable_value(
                        status,
                        `${m}_RESTRAINT_${occ}_SIDE_AIRBAG_DEPLOYMENT_DEMERIT`,
                        "float"
                    );
                    passenger_demerits[3] = get_variable_value(
                        status,
                        `${m}_RESTRAINT_${occ}_HEAD_LATERAL_MOVEMENT_DEMERIT`,
                        "float"
                    );
                    passenger_demerits[4] = get_variable_value(
                        status,
                        `${m}_RESTRAINT_${occ}_OCCUPANT_BURN_RISK_DEMERIT`,
                        "float"
                    );
                    passenger_demerits[5] = get_variable_value(
                        status,
                        `${m}_RESTRAINT_${occ}_SEAT_INSTABILITY_DEMERIT`,
                        "float"
                    );
                    //Looking for the varibles that will automatically downgarde the score to POOR
                    var passenger_auto_poor = new Array(3);
                    passenger_auto_poor[0] = get_variable_value(
                        status,
                        `${m}_RESTRAINT_${occ}_LATE_AIRBAG_DEPLOYMENT_DEMERIT`,
                        "string"
                    );
                    passenger_auto_poor[1] = get_variable_value(
                        status,
                        `${m}_RESTRAINT_${occ}_SEAT_ATTACHMENT_DEMERIT`,
                        "string"
                    );
                    passenger_auto_poor[2] = get_variable_value(
                        status,
                        `${m}_RESTRAINT_${occ}_VEHICLE_DOOR_DEMERIT`,
                        "string"
                    );

                    break;
            }

            if (occ == "DRIVER") {
                for (var i = 0; i < driver_demerits.length; i++) {
                    if (driver_demerits[i] == undefined || isNaN(driver_demerits[i])) driver_demerits[i] = 0;

                    total_demerits += driver_demerits[i];
                }
            } else if (occ == "PASSENGER") {
                for (var i = 0; i < passenger_demerits.length; i++) {
                    if (passenger_demerits[i] == undefined || isNaN(passenger_demerits[i])) passenger_demerits[i] = 0;

                    total_demerits += passenger_demerits[i];
                }
            }
            restraint_rating = "Good";
            if (total_demerits >= Poor) {
                restraint_rating = "Poor";
            } else if (total_demerits >= Marginal) {
                restraint_rating = "Marginal";
            } else if (total_demerits >= Acceptable) {
                restraint_rating = "Acceptable";
            }

            // Looking for the varibles that will automatically downgarde the score to POOR to see if they are set to POOR or OK
            if (occ == "DRIVER") {
                LogPrint(`Checking if ${m} ${occ} restraint rating should be automatically downgraded to Poor`);
                var set_to_poor = false;
                for (var i = 0; i < driver_auto_poor.length; i++)
                    if (driver_auto_poor[i] == "Poor") {
                        set_to_poor = true;
                        restraint_rating = "Poor";
                    }
            } else if (occ == "PASSENGER") {
                LogPrint(`Checking if ${m} ${occ} restraint rating should be downgarded to Poor`);
                for (var i = 0; i < passenger_auto_poor.length; i++)
                    if (passenger_auto_poor[i] == "Poor") {
                        set_to_poor = true;
                        restraint_rating = "Poor";
                    }
            }
            let RESTARINT_RATING_VAR = new Variable(
                templ,
                `${m}_${occ}_RESTRAINT_RATING`,
                "Restraint Rating",
                restraint_rating,
                "String",
                false,
                true
            );

            let RESTARINT_DEMERITS_VAR = new Variable(
                templ,
                `${m}_${occ}_TOTAL_RESTRAINT_DEMERITS`,
                "Restraint total demerits",
                total_demerits.toString(),
                "String",
                false,
                true
            );
            // Set text to explain how the rating was calculated

            var text = "";

            if (!set_to_poor) text += "\n";

            text +=
                "The overall rating is calculated by comparing the total number of demerits to the limits set in the regulation:\n\n";
            text += "   0-1 -> GOOD\n";
            text += "   2-3 -> ACCEPTABLE\n";
            text += "   4-5 -> MARGINAL\n";
            text += "   6+  -> POOR";

            if (set_to_poor) text += "\n\nHowever, one of the demerits has led to an automatic POOR.";

            var variable = new Variable(
                templ,
                `RESTRAINT_${occ}_TEXT`,
                "Text to explain how restraint rating was calculated",
                text,
                "General"
            );
        }
    }
}
