/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
pelvis();

/**
 * Performs the pelvis force and score calculation for the specified models
 */
function pelvis() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `pelvis`;

    let occupants = ["DRIVER", "REAR_DRIVER_SIDE"];
    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            let pelvis_rating_left = get_variable_value(status, `${m}_${occ}_PELVIS_FORCE_LEFT_MAX_RATING`);
            let pelvis_rating_right = get_variable_value(status, `${m}_${occ}_PELVIS_FORCE_RIGHT_MAX_RATING`);

            let pelvis_final_rating = "Not computed";

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                pelvis_final_rating = return_worst_IIHS_rating([pelvis_rating_left, pelvis_rating_right]);
            } else {
                warn_about_missing_or_invalid_variables(
                    status,
                    `${m} ${occ} ${body_region_label} value and rating calculation`
                );
            }

            new Variable(
                templ,
                `${m}_${occ}_PELVIS_FINAL_RATING`,
                `FINAL ${body_region_label} rating`,
                pelvis_final_rating,
                "String",
                false,
                true
            );
        }
    }
}
