/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
head_and_neck();

/**
 * Performs the head and neck rating calculation for the specified models
 */
function head_and_neck() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `head and neck`;

    let occupants = ["DRIVER", "REAR_DRIVER_SIDE"];
    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} rating...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            let head_hic_rating = get_variable_value(status, `${m}_${occ}_HEAD_HIC_RATING`, "string", false);
            let neck_axial_rating = get_variable_value(status, `${m}_${occ}_NECK_AXIAL_RATING`, "string", false);

            /* Final will be initialized as undefined and will remain so if any variables were missing or invalid */
            let head_hic_final_rating = undefined;
            let neck_axial_final_rating = undefined;
            let head_and_neck_final_rating = undefined;

            /* If we have all the required variables, calculate the final ratings*/
            if (status.success) {
                /*The head HIC final rating is the same as HIC rating*/

                head_hic_final_rating = head_hic_rating;

                /*The neck final rating is same as the neck axial rating*/

                neck_axial_final_rating = neck_axial_rating;

                head_and_neck_final_rating = return_worst_IIHS_rating([head_hic_final_rating, neck_axial_final_rating]);

                LogPrint(`${m} ${occ} HEAD HIC FINAL RATING = ${head_hic_final_rating}`);
                LogPrint(`${m} ${occ} NECK AXIAL FINAL RATING= ${neck_axial_final_rating}`);
                LogPrint(`${m} ${occ} HEAD AND NECK OVERALL RATING = ${head_and_neck_final_rating}`);
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} rating calculation`);
            }

            /* Overall ratings */

            let head_hic_rating_individual = new Variable(
                templ,
                `${m}_${occ}_HEAD_HIC_FINAL_RATING`,
                `Final head hic rating`,
                head_hic_final_rating.toString(),
                "String",
                false,
                true
            );

            let neck_axial_final_rating_overall = new Variable(
                templ,
                `${m}_${occ}_NECK_AXIAL_FINAL_RATING`,
                `Final neck axial rating`,
                neck_axial_final_rating.toString(),
                "String",
                false,
                true
            );

            let head_and_neck_final_rating_overall = new Variable(
                templ,
                `${m}_${occ}_HEAD_AND_NECK_FINAL_RATING`,
                `Final head and neck rating`,
                head_and_neck_final_rating.toString(),
                "String",
                false,
                true
            );
        }
    }
}
