/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
chest();

/**
 * Performs the torso force and score calculation for the specified models
 */
function chest() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `torso`;

    let occupants = ["DRIVER", "REAR_DRIVER_SIDE"];
    for (let m of models) {
        let downgrade_explanation = "";

        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Ratings which need to be read in*/

            let variable_values = get_multiple_variable_values(
                status,
                [
                    `${m}_${occ}_CHEST_COMPRESSION_UPPER_MAX_RATING`,
                    `${m}_${occ}_CHEST_COMPRESSION_MIDDLE_MAX_RATING`,
                    `${m}_${occ}_CHEST_COMPRESSION_LOWER_MAX_RATING`,
                    `${m}_${occ}_ABDOMEN_COMPRESSION_UPPER_MAX_RATING`,
                    `${m}_${occ}_ABDOMEN_COMPRESSION_LOWER_MAX_RATING`,
                    `${m}_${occ}_TORSO_AVERAGE_COMPRESSION_RATING`,
                    `${m}_${occ}_CHEST_COMPRESSION_RATE_UPPER_MAX_RATING`,
                    `${m}_${occ}_CHEST_COMPRESSION_RATE_MIDDLE_MAX_RATING`,
                    `${m}_${occ}_CHEST_COMPRESSION_RATE_LOWER_MAX_RATING`,
                    `${m}_${occ}_ABDOMEN_COMPRESSION_RATE_UPPER_MAX_RATING`,
                    `${m}_${occ}_ABDOMEN_COMPRESSION_RATE_LOWER_MAX_RATING`,
                    `${m}_${occ}_CHEST_VISCOUS_CRITERION_UPPER_MAX_RATING`,
                    `${m}_${occ}_CHEST_VISCOUS_CRITERION_MIDDLE_MAX_RATING`,
                    `${m}_${occ}_CHEST_VISCOUS_CRITERION_LOWER_MAX_RATING`,
                    `${m}_${occ}_ABDOMEN_VISCOUS_CRITERION_UPPER_MAX_RATING`,
                    `${m}_${occ}_ABDOMEN_VISCOUS_CRITERION_LOWER_MAX_RATING`
                ],
                "string",
                true
            );

            let shoulder_deflection_score = get_variable_value(
                status,
                `${m}_${occ}_SHOULDER_DEFLECTION_SCORE`,
                "float",
                true
            );

            /* If we have all the required variables, calculate the final rating */

            let torso_final_rating = "Not computed";
            let downgrade_variable = "";

            if (status.success) {
                torso_final_rating = return_worst_IIHS_rating(Object.values(variable_values));

                /* If the shoulder deflection score is less than 0 downgrade the rating by one unit.
                 *
                 * Also write a variable to say that it's been downgraded to display in the report.
                 */

                if (shoulder_deflection_score < 0) {
                    if (torso_final_rating == "Good") {
                        torso_final_rating = "Acceptable";
                    } else if (torso_final_rating == "Acceptable") {
                        torso_final_rating = "Marginal";
                    } else if (torso_final_rating == "Marginal") {
                        torso_final_rating = "Poor";
                    }

                    downgrade_variable = "*";
                    downgrade_explanation = "*Downgraded due to shoulder deflection";
                }
            } else {
                warn_about_missing_or_invalid_variables(
                    status,
                    `${m} ${occ} ${body_region_label} value and rating calculation`
                );
            }

            /* Overall rating */

            new Variable(
                templ,
                `${m}_${occ}_TORSO_FINAL_RATING`,
                `Final overall ${body_region_label} rating`,
                torso_final_rating.toString(),
                "String",
                false,
                true
            );

            new Variable(
                templ,
                `${m}_${occ}_TORSO_DOWNGRADE`,
                `Torso downgrade`,
                downgrade_variable,
                "String",
                false,
                true
            );
        }

        new Variable(
            templ,
            `${m}_TORSO_DOWNGRADE_EXPLANATION`,
            "Torso downgrade explanation",
            downgrade_explanation,
            "String",
            false,
            true
        );
    }
}
