/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
chest_score();

/**
 * Performs the chest and abdomen score calculation for the specified models
 */
function chest_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `chest`;

    let occupants = ["DRIVER"];
    for (let m of models) {
        /* Later we create a REPORTER variable to display an explanatory message if any capping
         * limit exceeded */
        let capping_limit_explanation = "";
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            let crash_test_type = get_variable_value(status, `TEMPLATE_CRASH_TEST`, "string");

            /* Chest score and modifiers */

            /* Driver */
            let comp_scores = get_multiple_variable_values(
                status,
                [
                    `${m}_${occ}_CHEST_COMPRESSION_UPPER_MAX_SCORE`,
                    `${m}_${occ}_CHEST_COMPRESSION_MIDDLE_MAX_SCORE`,
                    `${m}_${occ}_CHEST_COMPRESSION_LOWER_MAX_SCORE`
                ],
                "float",
                true
            );

            let vc_scores = get_multiple_variable_values(
                status,
                [
                    `${m}_${occ}_CHEST_VISCOUS_CRITERION_UPPER_MAX_SCORE`,
                    `${m}_${occ}_CHEST_VISCOUS_CRITERION_MIDDLE_MAX_SCORE`,
                    `${m}_${occ}_CHEST_VISCOUS_CRITERION_LOWER_MAX_SCORE`
                ],
                "float",
                true
            );

            let capping_limit_values = get_multiple_variable_values(
                status,
                [
                    `${m}_${occ}_CHEST_COMPRESSION_UPPER_MAX_CAPPING_LIMIT`,
                    `${m}_${occ}_CHEST_COMPRESSION_MIDDLE_MAX_CAPPING_LIMIT`,
                    `${m}_${occ}_CHEST_COMPRESSION_LOWER_MAX_CAPPING_LIMIT`,
                    `${m}_${occ}_CHEST_VISCOUS_CRITERION_UPPER_MAX_CAPPING_LIMIT`,
                    `${m}_${occ}_CHEST_VISCOUS_CRITERION_MIDDLE_MAX_CAPPING_LIMIT`,
                    `${m}_${occ}_CHEST_VISCOUS_CRITERION_LOWER_MAX_CAPPING_LIMIT`
                ],
                "string",
                true
            );

            let back_plate_mod;
            let t12_loading_scoring;
            let t12_moment_scoring;
            let t12_mod;

            let incorrect_airbag_mod = get_variable_value(
                status,
                `${m}_CHEST_INCORRECT_AIRBAG_DEPLOYMENT_MODIFIER`,
                "int"
            );

            /**Modifiers */
            if (crash_test_type.toUpperCase() == "MDB") {
                back_plate_mod = get_variable_value(status, `${m}_${occ}_BACKPLATE_FORCE_SCORE`, "float");

                t12_loading_scoring = get_variable_value(status, `${m}_${occ}_T12_FORCE_SCORE`, "float");

                t12_moment_scoring = get_variable_value(status, `${m}_${occ}_T12_MOMENT_SCORE`, "float");

                t12_mod = Math.min(t12_loading_scoring, t12_moment_scoring);

                new Variable(
                    templ,
                    `${m}_${occ}_T12_MODIFIER`,
                    "Final T12 modifier",
                    t12_mod.toString(),
                    "String",
                    false,
                    true
                );
            }

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let chest_compression_score = 0;
            let chest_vc_score = 0;
            let chest_score = 0;
            /* Capping limits start as exceeded and will remain so if any variables were missing or invalid */
            let chest_capping_limit = "*";

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                /* Score calculation is different for different occupants */

                /* Check capping limits. If any individual limits are exceeded, an asterisk is
                 * displayed for all parent body regions. */
                if (return_capping_limit(Object.values(capping_limit_values)) == "") {
                    chest_capping_limit = "";
                } else {
                    capping_limit_explanation = `*Capping limit exceeded`;
                }

                /*We calculate the maximum of the left and right upper/lower values so we can display it in the table */
                /* Chest score is minimum of left and right scores, summed with modifiers */

                chest_compression_score = Math.min(...Object.values(comp_scores));
                chest_vc_score = Math.min(...Object.values(vc_scores));

                /**Modifiers */

                if (crash_test_type.toUpperCase() == "MDB") {
                    chest_score = Math.max(
                        0,
                        Math.min(chest_compression_score, chest_vc_score) +
                            back_plate_mod +
                            t12_mod +
                            incorrect_airbag_mod
                    );
                } else if (crash_test_type.toUpperCase() == "POLE") {
                    chest_score = Math.max(0, Math.min(chest_compression_score, chest_vc_score) + incorrect_airbag_mod);
                }

                LogPrint(`${m} ${occ} chest score = ${chest_score}`);
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            new Variable(
                templ,
                `${m}_${occ}_CHEST_COMPRESSION_SCORE`,
                "Minimum of Top, Middle and Bottom Chest Compression Scores",
                chest_compression_score.toString(),
                "String",
                false,
                true
            );
            new Variable(
                templ,
                `${m}_${occ}_CHEST_VISCOUS_CRITERION_SCORE`,
                "Minimum of Top, Middle and Bottom Viscous Criterion Scores",
                chest_vc_score.toString(),
                "String",
                false,
                true
            );

            new Variable(
                templ,
                `${m}_${occ}_CHEST_FINAL_SCORE`,
                "Final chest score",
                chest_score.toString(),
                "String",
                false,
                true
            );
            new Variable(
                templ,
                `${m}_${occ}_CHEST_CAPPING_LIMIT`,
                `Chest capping limit`,
                chest_capping_limit,
                "String",
                false,
                true
            );
        }

        new Variable(
            templ,
            `${m}_CHEST_CAPPING_LIMIT_EXPLANATION`,
            `Capping limit explanation`,
            capping_limit_explanation,
            "String",
            false,
            true
        );
    }
}
