/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
overall_score();

/**
 * Performs overall score calculation for the specified models
 */
function overall_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `overall`;

    let occupants = ["DRIVER"];
    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            let head_rating = get_variable_value(status, `${m}_${occ}_HEAD_RATING`, "string");
            let chest_rating = get_variable_value(status, `${m}_${occ}_CHEST_RATING`, "string");
            let pelvis_rating = get_variable_value(status, `${m}_${occ}_PELVIS_RATING`, "string");
            let abdomen_rating = get_variable_value(status, `${m}_${occ}_ABDOMEN_RATING`, "string");

            /*Overall score variable is initially set to False */
            let overall_rating = return_pass_or_fail(["failString"]);

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                overall_rating = return_pass_or_fail([head_rating, chest_rating, abdomen_rating, pelvis_rating]);

                new Variable(
                    templ,
                    `${m}_${occ}_RATING`,
                    `${occ} overall rating`,
                    overall_rating,
                    "String",
                    false,
                    true
                );
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }
        }
    }
}
