/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
draw_occupant_images();

/**
 * Draw occupant body region scoring indicator images for the specified models
 */
function draw_occupant_images() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let output_dir = get_expanded_variable_value(templ, `OUTPUT_DIR`);

    /* Checks if the output directory provided is valid */
    if (is_valid_output_dir(output_dir) == false) {
        LogPrint("Invalid output directory");
        return;
    }

    let occupants = ["DRIVER"];
    for (let m of models) {
        for (let occ of occupants) {
            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            let head_rating = get_variable_value(status, `${m}_${occ}_HEAD_RATING`, "string");
            let chest_rating = get_variable_value(status, `${m}_${occ}_CHEST_RATING`, "string");
            let pelvis_rating = get_variable_value(status, `${m}_${occ}_PELVIS_RATING`, "string");
            let abdomen_rating = get_variable_value(status, `${m}_${occ}_ABDOMEN_RATING`, "string");

            if (!status.success) {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} body region score indicator images`);
            }

            /* Create new image */
            let img = new Image(300, 342);
            img.lineWidth = 1;
            img.lineColour = "black";
            let steering_colour = "#000000";
            /* Draw the body regions */

            /* coloured in regions*/
            draw_side_view_head(img, get_fill_colour_UN(head_rating));
            draw_side_view_chest(img, get_fill_colour_UN(chest_rating));
            draw_side_view_abdomen(img, get_fill_colour_UN(abdomen_rating));
            draw_side_view_pelvis(img, get_fill_colour_UN(pelvis_rating));

            /*Not coloured in regions*/
            draw_side_view_neck(img, get_fill_colour_UN(null));
            draw_side_view_right_arm(img, get_fill_colour_UN(null));
            draw_side_view_right_leg(img, get_fill_colour_UN(null));

            if (occ == "DRIVER") {
                draw_side_view_steering_wheel(img, steering_colour);
            }
            LogPrint(`dummy image is saved to this name ${output_dir}/${m}_${occ.toLowerCase()}_plot.png`);
            img.Save(`${output_dir}/${m}_${occ.toLowerCase()}_plot.png`, Image.PNG);
        }
    }
}
