/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
head_and_neck_score();

/**
 * Performs the head and neck score calculation for the specified models
 */
function head_and_neck_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `head and neck`;

    let occupants = ["DRIVER", "FRONT_PASSENGER"];
    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Head and neck ratings */

            let head_hic_rating = get_variable_value(status, `${m}_${occ}_HEAD_HIC_RATING`, "string");
            let head_three_ms_exc_rating = get_variable_value(
                status,
                `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_RATING`,
                "string"
            );

            let neck_tension_rating = get_variable_value(status, `${m}_${occ}_NECK_AXIAL_RATING`, "string");

            // // Calulating N_ij rating
            let neck_nij_value;
            let N_TE = get_variable_value(status, `${m}_${occ}_NECK_NIJ_TENSION-EXTENSION_VALUE`, "float");
            let N_TF = get_variable_value(status, `${m}_${occ}_NECK_NIJ_TENSION-FLEXION_VALUE`, "float");
            let N_CE = get_variable_value(status, `${m}_${occ}_NECK_NIJ_COMPRESSION-EXTENSION_VALUE`, "float");
            let N_CF = get_variable_value(status, `${m}_${occ}_NECK_NIJ_COMPRESSION-FLEXION_VALUE`, "float");

            neck_nij_value = Math.max(N_TE, N_TF, N_CE, N_CF);
            const neck_nij_rating =
                neck_nij_value < 1.0 ? return_pass_or_fail(["passString"]) : return_pass_or_fail(["failString"]);

            /* Final ratings are set to fail and will remain so if any variables were missing or invalid */

            let overall_head_rating = return_pass_or_fail(["failString"]);
            let overall_neck_rating = return_pass_or_fail(["failString"]);
            let overall_head_and_neck_rating = return_pass_or_fail(["failString"]);

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                overall_head_rating = return_pass_or_fail([head_hic_rating, head_three_ms_exc_rating]);

                overall_neck_rating = return_pass_or_fail([neck_tension_rating, neck_nij_rating]);

                overall_head_and_neck_rating = return_pass_or_fail([overall_head_rating, overall_neck_rating]);

                new Variable(
                    templ,
                    `${m}_${occ}_NECK_NIJ_MAX_VALUE`,
                    `Maximum of all the N_ij values`,
                    neck_nij_value.toString(),
                    "String",
                    false,
                    true
                );

                new Variable(
                    templ,
                    `${m}_${occ}_NECK_NIJ_RATING`,
                    `Maximum of all the N_ij values`,
                    neck_nij_rating,
                    "String",
                    false,
                    true
                );

                new Variable(
                    templ,
                    `${m}_${occ}_HEAD_AND_NECK_RATING`,
                    `${occ} overall head and neck rating`,
                    overall_head_and_neck_rating,
                    "String",
                    false,
                    true
                );

                new Variable(
                    templ,
                    `${m}_${occ}_HEAD_RATING`,
                    `${occ} overall head rating`,
                    overall_head_rating,
                    "String",
                    false,
                    true
                );

                new Variable(
                    templ,
                    `${m}_${occ}_NECK_RATING`,
                    `${occ} overall neck rating`,
                    overall_neck_rating,
                    "String",
                    false,
                    true
                );
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }
        }
    }
}
