/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
overall_score();

/**
 * Performs overall score calculation for the specified models
 */
function overall_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `overall`;

    let occupants = ["DRIVER", "REAR_DRIVER_SIDE"];
    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            let head_rating = get_variable_value(status, `${m}_${occ}_HEAD_RATING`, "string");
            let chest_rating = get_variable_value(status, `${m}_${occ}_CHEST_RATING`, "string");
            let pelvis_rating = get_variable_value(status, `${m}_${occ}_PELVIS_RATING`, "string");
            let abdomen_rating = get_variable_value(status, `${m}_${occ}_ABDOMEN_RATING`, "string");

            let overall_rating_driver = return_pass_or_fail(["failString"]);
            let overall_rating_passenger = return_pass_or_fail(["failString"]);

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                if (occ == "DRIVER") {
                    overall_rating_driver = return_pass_or_fail([
                        head_rating,
                        chest_rating,
                        abdomen_rating,
                        pelvis_rating
                    ]);

                    new Variable(
                        templ,
                        `${m}_${occ}_RATING`,
                        `${occ} overall rating`,
                        overall_rating_driver,
                        "String",
                        false,
                        true
                    );
                } else {
                    overall_rating_passenger = return_pass_or_fail([head_rating, abdomen_rating, pelvis_rating]);

                    new Variable(
                        templ,
                        `${m}_${occ}_RATING`,
                        `${occ} overall rating`,
                        overall_rating_passenger,
                        "String",
                        false,
                        true
                    );
                }
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            /* Overall scores */
            let total_score = return_pass_or_fail(["failString"]);

            total_score = return_pass_or_fail([overall_rating_driver, overall_rating_passenger]);

            new Variable(templ, `${m}_TOTAL_SCORE`, " Total score", total_score.toString(), "String", false, true);
        }
    }
}
