/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
chest_score();

/**
 * Performs the head and neck score calculation for the specified models
 */
function chest_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `chest`;

    let occupants = ["DRIVER"];
    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Chest ratings */

            let chest_comp_upper_rating = get_variable_value(
                status,
                `${m}_${occ}_CHEST_COMPRESSION_UPPER_MAX_RATING`,
                "string"
            );
            let chest_comp_middle_rating = get_variable_value(
                status,
                `${m}_${occ}_CHEST_COMPRESSION_MIDDLE_MAX_RATING`,
                "string"
            );
            let chest_comp_lower_rating = get_variable_value(
                status,
                `${m}_${occ}_CHEST_COMPRESSION_LOWER_MAX_RATING`,
                "string"
            );

            /* Final scores is set to fail and will remain so if any variables were missing or invalid */
            let overall_chest_rating = return_pass_or_fail(["failString"]);

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                overall_chest_rating = return_pass_or_fail([
                    chest_comp_upper_rating,
                    chest_comp_middle_rating,
                    chest_comp_lower_rating
                ]);

                new Variable(
                    templ,
                    `${m}_${occ}_CHEST_RATING`,
                    `${occ} overall chest rating`,
                    overall_chest_rating,
                    "String",
                    false,
                    true
                );
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }
        }
    }
}
