/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
head_and_neck_score();

/**
 * Performs the head and neck score calculation for the specified models
 */
function head_and_neck_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `head and neck`;

    let occupants = ["DRIVER", "FRONT_PASSENGER"];
    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Head and neck ratings */

            let head_hic15_rating = get_variable_value(status, `${m}_${occ}_HEAD_HIC15_RATING`, "string");

            /** Get N_ij rating*/
            let N_TE_rating = get_variable_value(status, `${m}_${occ}_NECK_NIJ_TENSION-EXTENSION_RATING`, "string");
            let N_TF_rating = get_variable_value(status, `${m}_${occ}_NECK_NIJ_TENSION-FLEXION_RATING`, "string");
            let N_CE_rating = get_variable_value(status, `${m}_${occ}_NECK_NIJ_COMPRESSION-EXTENSION_RATING`, "string");
            let N_CF_rating = get_variable_value(status, `${m}_${occ}_NECK_NIJ_COMPRESSION-FLEXION_RATING`, "string");
            let neck_axial_rating = get_variable_value(status, `${m}_${occ}_NECK_AXIAL_RATING`, "string");

            /* Final ratings are set to fail and will remain so if any variables were missing or invalid */

            let overall_head_rating = return_pass_or_fail(["failString"]);
            let overall_neck_rating = return_pass_or_fail(["failString"]);
            let overall_head_and_neck_rating = return_pass_or_fail(["failString"]);

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                overall_head_rating = return_pass_or_fail([head_hic15_rating]);
                overall_neck_rating = return_pass_or_fail([
                    N_TE_rating,
                    N_TF_rating,
                    N_CE_rating,
                    N_CF_rating,
                    neck_axial_rating
                ]);
                overall_head_and_neck_rating = return_pass_or_fail([overall_head_rating, overall_neck_rating]);
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            new Variable(
                templ,
                `${m}_${occ}_HEAD_AND_NECK_RATING`,
                `${occ} overall head and neck rating`,
                overall_head_and_neck_rating,
                "String",
                false,
                true
            );

            new Variable(
                templ,
                `${m}_${occ}_HEAD_RATING`,
                `${occ} overall head rating`,
                overall_head_rating,
                "String",
                false,
                true
            );

            new Variable(
                templ,
                `${m}_${occ}_NECK_RATING`,
                `${occ} overall neck rating`,
                overall_neck_rating,
                "String",
                false,
                true
            );
        }
    }
}
