/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
head_and_neck_score();

/**
 * Performs the head and neck score calculation for the specified models
 */
function head_and_neck_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `head and neck`;

    let occupants = ["DRIVER", "FRONT_PASSENGER"];
    for (let m of models) {
        /* Later we create a REPORTER variable to display an explanatory message if any capping
         * limit exceeded */
        let capping_limit_explanation = "";
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Head score and modifiers */

            /* Shared */
            let head_hic_score = get_variable_value(status, `${m}_${occ}_HEAD_HIC_SCORE`, "float");
            let head_tms_exceedence_score = get_variable_value(
                status,
                `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_SCORE`,
                "float"
            );
            let head_accn_score = get_variable_value(status, `${m}_${occ}_HEAD_PEAK_ACCELERATION_SCORE`, "float");
            let head_hic_capping_limit = get_variable_value(status, `${m}_${occ}_HEAD_HIC_CAPPING_LIMIT`);
            let head_tms_capping_limit = get_variable_value(
                status,
                `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_CAPPING_LIMIT`
            );
            let head_accn_capping_limit = get_variable_value(
                status,
                `${m}_${occ}_HEAD_PEAK_ACCELERATION_CAPPING_LIMIT`
            );
            let haz_ab_mod = get_variable_value(status, `${m}_${occ}_HEAD_HAZARDOUS_AIRBAG_DEPLOYMENT_MODIFIER`, "int");
            let inc_ab_mod = get_variable_value(status, `${m}_${occ}_HEAD_INCORRECT_AIRBAG_DEPLOYMENT_MODIFIER`, "int");
            let ab_con_mod = get_variable_value(status, `${m}_${occ}_HEAD_AIRBAG_CONTACT_MODIFIER`, "int");

            /* If the head peak acceleration is less than 80g and score is 4 other scores hic and 3 ms exc should be zero */

            if (head_accn_score == 4) {
                head_hic_score = 0;
                head_tms_exceedence_score = 0;
                /* Update the score variables in REPORTER */
                let head_hic_score_var = new Variable(
                    templ,
                    `${m}_${occ}_HEAD_HIC_SCORE`,
                    "Head peak acceleration score is 4, so head HIC score revised to 0.",
                    head_hic_score.toString(),
                    "String",
                    false,
                    true
                );
                let head_three_ms_exc_score_var = new Variable(
                    templ,
                    `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_SCORE`,
                    "Head peak acceleration score is 4, so head TMS score revised to 0.",
                    head_tms_exceedence_score.toString(),
                    "String",
                    false,
                    true
                );
            }

            /*Driver */
            let steering_wheel_airbag_present;
            let steering_column_intrusion_x_score;
            let steering_column_intrusion_y_score;
            let steering_column_intrusion_z_score;
            if (occ == "DRIVER") {
                steering_wheel_airbag_present = get_variable_value(
                    status,
                    `${m}_${occ}_STEERING_WHEEL_AIRBAG_MODIFIER`
                );
                steering_column_intrusion_x_score = get_variable_value(
                    status,
                    `${m}_STRUCTURE_STEERING_COLUMN_FORE_AFT_INTRUSION_SCORE`,
                    "float"
                );
                steering_column_intrusion_y_score = get_variable_value(
                    status,
                    `${m}_STRUCTURE_STEERING_COLUMN_LATERAL_INTRUSION_SCORE`,
                    "float"
                );
                steering_column_intrusion_z_score = get_variable_value(
                    status,
                    `${m}_STRUCTURE_STEERING_COLUMN_VERTICAL_INTRUSION_SCORE`,
                    "float"
                );
            }

            /* Neck score */
            let neck_tension_exceedence_score;
            let neck_shear_exceedence_score;
            let neck_extension_score;
            let neck_tension_exceedence_capping_limit;
            let neck_shear_exceedence_capping_limit;
            let neck_extension_capping_limit;

            neck_tension_exceedence_score = get_variable_value(
                status,
                `${m}_${occ}_NECK_TENSION_EXCEEDENCE_SCORE`,
                "float"
            );
            neck_extension_score = get_variable_value(status, `${m}_${occ}_NECK_EXTENSION_SCORE`, "float");
            neck_shear_exceedence_score = get_variable_value(
                status,
                `${m}_${occ}_NECK_SHEAR_EXCEEDENCE_SCORE`,
                "float"
            );
            neck_tension_exceedence_capping_limit = get_variable_value(
                status,
                `${m}_${occ}_NECK_TENSION_EXCEEDENCE_CAPPING_LIMIT`
            );
            neck_shear_exceedence_capping_limit = get_variable_value(
                status,
                `${m}_${occ}_NECK_SHEAR_EXCEEDENCE_CAPPING_LIMIT`
            );
            neck_extension_capping_limit = get_variable_value(status, `${m}_${occ}_NECK_EXTENSION_CAPPING_LIMIT`);

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let head_score = 0;
            let neck_score = 0;
            let head_and_neck_score = 0;
            /* Capping limits start as exceeded and will remain so if any variables were missing or invalid */
            let head_capping_limit = "*";
            let neck_capping_limit = "*";
            let head_neck_capping_limit = "*";

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                /* Head score is sum of score with modifiers.
                 * For the driver, steering wheel airbag must be present or score remains zero. */

                if (occ != "DRIVER" || steering_wheel_airbag_present == "Yes") {
                    head_score =
                        Math.max(head_accn_score, Math.min(head_hic_score, head_tms_exceedence_score)) +
                        haz_ab_mod +
                        inc_ab_mod +
                        ab_con_mod;

                    if (occ == "DRIVER") {
                        /* For the driver, also add the steering column intrusion modifier */
                        let steering_column_intrusion_min_score = Math.min(
                            steering_column_intrusion_x_score,
                            steering_column_intrusion_y_score,
                            steering_column_intrusion_z_score
                        );
                        head_score += steering_column_intrusion_min_score;

                        let steering_column_intrusion_min_score_var = new Variable(
                            templ,
                            `${m}_STRUCTURE_STEERING_COLUMN_INTRUSION_MIN_SCORE`,
                            `Minimum of fore-aft, vertical, and lateral steering column intrusion modifiers`,
                            head_and_neck_score.toString(),
                            "String",
                            false,
                            true
                        );
                    }
                }

                /* Neck score is minimum of axial, shear, and bending components */

                neck_score = Math.min(neck_tension_exceedence_score, neck_shear_exceedence_score, neck_extension_score);

                /* Bound the score between upper and lower limits */

                head_score = Math.max(Math.min(head_score, 4.0), 0.0);
                neck_score = Math.max(Math.min(neck_score, 4.0), 0.0);

                LogPrint(`${m} ${occ} head score = ${head_score}`);
                LogPrint(`${m} ${occ} neck score = ${neck_score}`);

                /* Overall score is minimum of head and neck scores */

                head_and_neck_score = Math.min(head_score, neck_score);

                /* Check capping limits. If any individual limits are exceeded, an asterisk is
                 * displayed for all parent body regions. */

                if (head_hic_capping_limit == "" && head_tms_capping_limit == "" && head_accn_capping_limit == "") {
                    head_capping_limit = "";
                }

                if (
                    neck_tension_exceedence_capping_limit == "" &&
                    neck_shear_exceedence_capping_limit == "" &&
                    neck_extension_capping_limit == ""
                ) {
                    neck_capping_limit = "";
                }
                if (head_capping_limit == "" && neck_capping_limit == "") {
                    head_neck_capping_limit = "";
                } else {
                    capping_limit_explanation = `*Capping limit exceeded`;
                }
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            /* Overall scores */
            let head_score_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_FINAL_SCORE`,
                "Final head score",
                head_score.toString(),
                "String",
                false,
                true
            );
            let neck_score_var = new Variable(
                templ,
                `${m}_${occ}_NECK_FINAL_SCORE`,
                "Final neck score",
                neck_score.toString(),
                "String",
                false,
                true
            );
            let head_neck_score_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_NECK_FINAL_SCORE`,
                `Final ${body_region_label} score`,
                head_and_neck_score.toString(),
                "String",
                false,
                true
            );

            /* Capping limits */
            let head_capping_limit_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_CAPPING_LIMIT`,
                "Head capping limit (*asterisk if limit exceeded; empty string otherwise)",
                head_capping_limit,
                "String",
                false,
                true
            );
            let neck_capping_limit_var = new Variable(
                templ,
                `${m}_${occ}_NECK_CAPPING_LIMIT`,
                "Neck capping limit (*asterisk if limit exceeded; empty string otherwise)",
                neck_capping_limit,
                "String",
                false,
                true
            );
            let head_neck_capping_limit_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_NECK_CAPPING_LIMIT`,
                "Head and neck capping limit (*asterisk if limit exceeded; empty string otherwise)",
                head_neck_capping_limit,
                "String",
                false,
                true
            );
        }
        let capping_limit_explanation_var = new Variable(
            templ,
            `${m}_HEAD_NECK_CAPPING_LIMIT_EXPLANATION`,
            `Capping limit explanation`,
            capping_limit_explanation,
            "String",
            false,
            true
        );
    }
}
