/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
knee_femur_and_pelvis_score();

/**
 * Performs the knee, femur and pelvis score calculation for the specified models
 */
function knee_femur_and_pelvis_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `knee, femur and pelvis`;

    let occupants = ["DRIVER", "FRONT_PASSENGER", "REAR_PASSENGER_SIDE"];
    let sides = ["LEFT", "RIGHT"];
    let side_scores = {};
    let side_scores_nomod = {};
    let side_points = {};
    let knee_femur_pelvis_final_points = 0;
    let modifier_total = {}; // To be populated with score for each side
    for (let m of models) {
        for (let occ of occupants) {
            for (let side of sides) {
                LogPrint(`Calculating ${m} ${occ} ${side} ${body_region_label} score...`);

                /* Create a status object to track whether REPORTER Variables are all present and valid.
                 * <success> is initially true but will be set to false if anything missing or invalid. */
                let status = { success: true, missing: [], invalid: [] };

                /* Knee, femur and pelvis score and modifiers */

                /* Front Passenger */
                let acetabular_score;
                let acetabular_score_banded;

                acetabular_score = get_variable_value_and_ENCAP_band_score(
                    status,
                    `${m}_FRONT_PASSENGER_ACETABULAR_FORCE_${side}_SCORE`,
                    "float",
                    templ
                );
                acetabular_score_banded = get_variable_value(
                    status,
                    `${m}_FRONT_PASSENGER_ACETABULAR_FORCE_${side}_SCORE_ENCAP_BANDED`,
                    "float"
                );

                let submarining_mod = getModifierValue(status, `${m}_FRONT_PASSENGER_SUBMARINING_MODIFIER`);

                /* Shared */
                let femur_score;
                let femur_score_passenger;
                let knee_score;
                let femur_score_banded;
                let femur_score_passenger_banded;
                let knee_score_banded;
                let knee_var_contact_mod;
                let knee_conc_load_mod;
                let knee_incorrect_ab_mod;

                /* Variables extracted for all occupants */
                if (occ == "DRIVER" || occ == "REAR_PASSENGER_SIDE") {
                    femur_score = get_variable_value_and_ENCAP_band_score(
                        status,
                        `${m}_${occ}_${side}_FEMUR_COMPRESSION_SCORE`,
                        "float",
                        templ
                    );
                    knee_score = get_variable_value_and_ENCAP_band_score(
                        status,
                        `${m}_${occ}_${side}_KNEE_COMPRESSION_SCORE`,
                        "float",
                        templ
                    );
                    knee_score_banded = get_variable_value(
                        status,
                        `${m}_${occ}_${side}_KNEE_COMPRESSION_SCORE_ENCAP_BANDED`,
                        "float"
                    );
                    femur_score_banded = get_variable_value(
                        status,
                        `${m}_${occ}_${side}_FEMUR_COMPRESSION_SCORE_ENCAP_BANDED`,
                        "float"
                    );
                } else {
                    femur_score_passenger = get_variable_value_and_ENCAP_band_score(
                        status,
                        `${m}_FRONT_PASSENGER_${side}_FEMUR_COMPRESSION_PASSENGER_SCORE`,
                        "float",
                        templ
                    );
                    femur_score_passenger_banded = get_variable_value(
                        status,
                        `${m}_FRONT_PASSENGER_${side}_FEMUR_COMPRESSION_PASSENGER_SCORE_ENCAP_BANDED`,
                        "float"
                    );
                    knee_score = get_variable_value_and_ENCAP_band_score(
                        status,
                        `${m}_${occ}_${side}_KNEE_COMPRESSION_SCORE`,
                        "float",
                        templ
                    );
                    knee_score_banded = get_variable_value(
                        status,
                        `${m}_${occ}_${side}_KNEE_COMPRESSION_SCORE_ENCAP_BANDED`,
                        "float"
                    );
                }

                knee_var_contact_mod = getModifierValue(status, `${m}_${occ}_${side}_KNEE_VARIABLE_CONTACT_MODIFIER`);
                knee_conc_load_mod = getModifierValue(status, `${m}_${occ}_${side}_KNEE_CONCENTRATED_LOADING_MODIFIER`);
                knee_incorrect_ab_mod = getModifierValue(
                    status,
                    `${m}_${occ}_KNEE_INCORRECT_AIRBAG_DEPLOYMENT_MODIFIER`
                );

                /*knee_score = get_variable_value(status, `${m}_${occ}_${side}_KNEE_COMPRESSION_SCORE`, "float");

                /* Final scores all start at zero and will remain so if any variables were missing or invalid */
                side_scores[side] = 0;
                side_scores_nomod[side] = 0;
                side_points[side] = 0;
                modifier_total[side] = knee_var_contact_mod + knee_conc_load_mod + knee_incorrect_ab_mod;

                /* Score calculation is different for different occupants */
                switch (occ) {
                    case "DRIVER":
                        /* Left/right score is minimum of acetabular, femur and knee scores, summed with modifiers */
                        side_scores[side] = Math.max(
                            0,
                            Math.min(femur_score_banded, knee_score_banded) +
                                knee_var_contact_mod +
                                knee_conc_load_mod +
                                knee_incorrect_ab_mod
                        );
                        side_scores_nomod[side] = Math.max(0, Math.min(femur_score_banded, knee_score_banded));
                        knee_femur_pelvis_final_points = Math.min(side_scores.LEFT, side_scores.RIGHT);
                        knee_femur_pelvis_final_points = (knee_femur_pelvis_final_points / 100) * 1.25;
                        knee_femur_pelvis_final_points = replaceNaNWithMissing(knee_femur_pelvis_final_points);
                        break;
                    case "REAR_PASSENGER_SIDE":
                        /* Left/right score is minimum of acetabular, femur and knee scores, summed with modifiers */
                        side_scores[side] = Math.max(
                            0,
                            Math.min(femur_score_banded, knee_score_banded) +
                                knee_var_contact_mod +
                                knee_conc_load_mod +
                                knee_incorrect_ab_mod
                        );
                        side_scores_nomod[side] = Math.max(0, Math.min(femur_score_banded, knee_score_banded));
                        knee_femur_pelvis_final_points = Math.min(side_scores.LEFT, side_scores.RIGHT);
                        knee_femur_pelvis_final_points = (knee_femur_pelvis_final_points / 100) * 0.625;
                        knee_femur_pelvis_final_points = replaceNaNWithMissing(knee_femur_pelvis_final_points);
                        break;
                    case "FRONT_PASSENGER":
                        /* Left/right score is minimum of femur and knee scores, summed with modifiers */
                        side_scores[side] = Math.max(
                            0,
                            Math.min(femur_score_passenger_banded, knee_score_banded, acetabular_score_banded) +
                                knee_var_contact_mod +
                                knee_conc_load_mod +
                                knee_incorrect_ab_mod +
                                submarining_mod
                        );
                        side_scores_nomod[side] = Math.max(
                            0,
                            Math.min(femur_score_passenger_banded, knee_score_banded, acetabular_score_banded)
                        );
                        knee_femur_pelvis_final_points = Math.min(side_scores.LEFT, side_scores.RIGHT);
                        knee_femur_pelvis_final_points = (knee_femur_pelvis_final_points / 100) * 0.625;
                        knee_femur_pelvis_final_points = replaceNaNWithMissing(knee_femur_pelvis_final_points);
                        break;

                    default:
                        LogError(`Unexpected occupant type "${occ}" in ${body_region_label} calculation.`);
                        Exit();
                }

                replaceNaNWithMissing(side_scores);
                replaceNaNWithMissing(side_scores_nomod);

                LogPrint(`${m} ${occ} ${side} ${body_region_label} score = ${side_scores[side]}`);

                let side_score_var = new_variable_and_new_euroNCAP_banded_score(
                    templ,
                    `${m}_${occ}_KNEE_FEMUR_PELVIS_${side}_FINAL_SCORE`,
                    `Final ${side} ${body_region_label} score`,
                    side_scores[side].toString(),
                    "String",
                    false,
                    true
                );
                let side_score_nomod_var = new_variable_and_new_euroNCAP_banded_score(
                    templ,
                    `${m}_${occ}_KNEE_FEMUR_PELVIS_${side}_FINAL_SCORE_NOMOD`,
                    `Final ${side} ${body_region_label} score`,
                    side_scores_nomod[side].toString(),
                    "String",
                    false,
                    true
                );
                let modifier_total_var = new Variable(
                    templ,
                    `${m}_${occ}_${side}_MODIFIER_TOTAL`,
                    `Final ${side} ${body_region_label} modifier`,
                    modifier_total[side].toString(),
                    "String",
                    false,
                    true
                );
            }

            /* Overall score for each occupant is minimum of left and right scores */
            let knee_femur_pelvis_final_score = Math.min(side_scores.LEFT, side_scores.RIGHT);
            knee_femur_pelvis_final_score = replaceNaNWithMissing(knee_femur_pelvis_final_score);
            let knee_femur_pelvis_final_score_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_KNEE_FEMUR_PELVIS_FINAL_SCORE`,
                `Final ${body_region_label} score`,
                knee_femur_pelvis_final_score.toString(),
                "String",
                false,
                true
            );
            let knee_femur_pelvis_final_points_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_KNEE_FEMUR_PELVIS_FINAL_POINTS`,
                `Final ${body_region_label} score`,
                knee_femur_pelvis_final_points.toString(),
                "String",
                false,
                true
            );
        }
    }
}
