/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
head_score();

/**
 * Performs the head score calculation for the specified models
 */
function head_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `head`;

    let occupants = ["DRIVER"];
    for (let m of models) {
        /* Later we create a REPORTER variable to display an explanatory message if any capping
         * limit exceeded */
        let capping_limit_explanation = "";
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Head score */
            let head_hic_score = get_variable_value(status, `${m}_${occ}_HEAD_HIC_SCORE`, "float");
            let head_hic_value = get_variable_value(status, `${m}_${occ}_HEAD_HIC_HIC_VALUE`, "float");
            let head_hic_capping_limit = get_variable_value(status, `${m}_${occ}_HEAD_HIC_CAPPING_LIMIT`);

            var head_tms_exceedence_score = get_variable_value(
                status,
                `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_SCORE`,
                "float"
            );
            var head_tmd_exceedence_value = get_variable_value(
                status,
                `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_3MS_VALUE`,
                "float"
            );
            var head_tms_capping_limit = get_variable_value(
                status,
                `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_CAPPING_LIMIT`
            );

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let head_score = 0;
            /* Capping limits start as exceeded and will remain so if any variables were missing or invalid */
            let head_capping_limit = "*";

            let crash_test_type = get_variable_value(status, `TEMPLATE_CRASH_TEST`, "string");

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                head_score = Math.max(0, Math.min(head_tms_exceedence_score, head_hic_score));

                /* Check capping limits. If any individual limits are exceeded, an asterisk is
                 * displayed for all parent body regions. */
                if (head_hic_capping_limit == "" && head_tms_capping_limit == "") {
                    head_capping_limit = "";
                } else {
                    capping_limit_explanation = `*Capping limit exceeded`;
                }
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            /* bounding the scores between 0 and 4 */
            if (head_score < 0.0) {
                head_score = 0.0;
            }
            if (head_score > 4.0) {
                head_score = 4.0;
            }
            /* Overall scores */
            let head_score_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_FINAL_SCORE`,
                "Final head score",
                head_score.toString(),
                "String",
                false,
                true
            );

            /* Capping limits */
            let head_capping_limit_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_CAPPING_LIMIT`,
                "Head capping limit (*asterisk if limit exceeded; empty string otherwise)",
                head_capping_limit,
                "String",
                false,
                true
            );
        }
        let capping_limit_explanation_var = new Variable(
            templ,
            `${m}_HEAD_CAPPING_LIMIT_EXPLANATION`,
            `Capping limit explanation`,
            capping_limit_explanation,
            "String",
            false,
            true
        );
    }
}
