/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
tibia_score();

/**
 * Performs the tibia score calculation for the specified models
 */

function tibia_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `tibia`;

    let occupants = ["DRIVER", "FRONT_PASSENGER"];

    for (let m of models) {
        let frt_row_score_tibia = 0.0;
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Tibia scores */
            let up_le_ti_score = get_variable_value(status, `${m}_${occ}_LEFT_TIBIA_INDEX_UPPER_MAX_SCORE`, "float");
            let lo_le_ti_score = get_variable_value(status, `${m}_${occ}_LEFT_TIBIA_INDEX_LOWER_MAX_SCORE`, "float");
            let up_ri_ti_score = get_variable_value(status, `${m}_${occ}_RIGHT_TIBIA_INDEX_UPPER_MAX_SCORE`, "float");
            let lo_ri_ti_score = get_variable_value(status, `${m}_${occ}_RIGHT_TIBIA_INDEX_LOWER_MAX_SCORE`, "float");
            let up_le_tib_comp_f_score = get_variable_value(
                status,
                `${m}_${occ}_LEFT_TIBIA_COMPRESSION_UPPER_MAX_SCORE`,
                "float"
            );
            let lo_le_tib_comp_f_score = get_variable_value(
                status,
                `${m}_${occ}_LEFT_TIBIA_COMPRESSION_LOWER_MAX_SCORE`,
                "float"
            );
            let up_ri_tib_comp_f_score = get_variable_value(
                status,
                `${m}_${occ}_RIGHT_TIBIA_COMPRESSION_UPPER_MAX_SCORE`,
                "float"
            );
            let lo_ri_tib_comp_f_score = get_variable_value(
                status,
                `${m}_${occ}_RIGHT_TIBIA_COMPRESSION_LOWER_MAX_SCORE`,
                "float"
            );

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let tibia_score = 0.0;
            /* Used later in drawing script for dummy infographic */
            let tibia_score_le = 0.0;
            let tibia_score_ri = 0.0;

            /* If we have all the required variables, calculate the final scores */
            /* Ref. Table 3-12 on Chapter.III of C-NCAP 2024 Management Regulation */
            if (status.success) {
                tibia_score = Math.min(
                    up_le_ti_score,
                    lo_le_ti_score,
                    up_ri_ti_score,
                    lo_ri_ti_score,
                    up_le_tib_comp_f_score,
                    lo_le_tib_comp_f_score,
                    up_ri_tib_comp_f_score,
                    lo_ri_tib_comp_f_score
                );

                tibia_score_le = Math.min(
                    up_le_ti_score,
                    lo_le_ti_score,
                    up_le_tib_comp_f_score,
                    lo_le_tib_comp_f_score
                );

                tibia_score_ri = Math.min(
                    up_ri_ti_score,
                    lo_ri_ti_score,
                    up_ri_tib_comp_f_score,
                    lo_ri_tib_comp_f_score
                );

                /* Bound the score between upper and lower limits */
                tibia_score = Math.max(tibia_score, 0.0);
                LogPrint(`${m} ${occ} tibia score = ${tibia_score}`);

                if (occ == "DRIVER") {
                    frt_row_score_tibia = tibia_score;
                }

                if (occ == "FRONT_PASSENGER" && tibia_score < frt_row_score_tibia) {
                    frt_row_score_tibia = tibia_score;
                }
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            /* Overall scores */
            let tibia_score_var = new Variable(
                templ,
                `${m}_${occ}_TIBIA_FINAL_SCORE`,
                "Final tibia score",
                tibia_score.toString(),
                "String",
                false,
                true
            );
            let tibia_score_le_var = new Variable(
                templ,
                `${m}_${occ}_TIBIA_LEFT_FINAL_SCORE`,
                "Final left tibia score",
                tibia_score_le.toString(),
                "String",
                false,
                true
            );
            let tibia_score_ri_var = new Variable(
                templ,
                `${m}_${occ}_TIBIA_RIGHT_FINAL_SCORE`,
                "Final right tibia score",
                tibia_score_ri.toString(),
                "String",
                false,
                true
            );
        }
        let front_row_score_tibia_var = new Variable(
            templ,
            `${m}_FRONT_ROW_TIBIA_SCORE`,
            "Final lower leg score",
            frt_row_score_tibia.toString(),
            "String",
            false,
            true
        );
    }
}
