/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
femur_and_knee_score();

/**
 * Performs the femur and knee score calculation for the specified models
 */

function femur_and_knee_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `femur_and_knee`;

    let occupants = ["DRIVER", "FRONT_PASSENGER"];

    for (let m of models) {
        let frt_row_score = 0.0;
        let femur_and_knee_score_driver = 0.0;
        let femur_and_knee_front_passenger = 0.0;

        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Femur and knee scores and modifiers */
            let l_femur_comp_f_score = get_variable_value(
                status,
                `${m}_${occ}_LEFT_FEMUR_COMPRESSION_EXCEEDENCE_SCORE`,
                "float"
            );
            let r_femur_comp_f_score = get_variable_value(
                status,
                `${m}_${occ}_RIGHT_FEMUR_COMPRESSION_EXCEEDENCE_SCORE`,
                "float"
            );
            let l_knee_comp_score = get_variable_value(status, `${m}_${occ}_LEFT_KNEE_COMPRESSION_SCORE`, "float");
            let r_knee_comp_score = get_variable_value(status, `${m}_${occ}_RIGHT_KNEE_COMPRESSION_SCORE`, "float");

            let leg_var_cont_mod = get_variable_value(status, `${m}_${occ}_FEMUR_VARIABLE_CONTACT_MODIFIER`, "int");
            let leg_con_load_mod = get_variable_value(status, `${m}_${occ}_FEMUR_CONCENTRATED_LOAD_MODIFIER`, "int");
            let knee_ab_dplo_mod = get_variable_value(
                status,
                `${m}_${occ}_KNEE_INCORRECT_AIRBAG_DEPLOYMENT_MODIFIER`,
                "int"
            );

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let femur_and_knee_score = 0.0;
            let femur_and_knee_score_le = 0.0;
            let femur_and_knee_score_ri = 0.0;

            /* Record the modifiers */
            let femur_and_knee_mod = 0.0;
            let femur_and_knee_score_no_mod = 0.0;

            /* If we have all the required variables, calculate the final scores */
            /* Ref. Table 3-12 on Chapter.III of C-NCAP 2024 Management Regulation */
            if (status.success) {
                femur_and_knee_mod = leg_var_cont_mod + leg_con_load_mod + knee_ab_dplo_mod;
                femur_and_knee_score_no_mod = Math.min(
                    l_femur_comp_f_score,
                    r_femur_comp_f_score,
                    l_knee_comp_score,
                    r_knee_comp_score
                );

                femur_and_knee_score = femur_and_knee_score_no_mod + femur_and_knee_mod;
                femur_and_knee_score = Math.max(femur_and_knee_score, 0.0);
                LogPrint(`${m} ${occ} femur and knee score = ${femur_and_knee_score}`);

                if (occ == "DRIVER") {
                    femur_and_knee_score_driver = femur_and_knee_score;
                }
                if (occ == "FRONT_PASSENGER") {
                    femur_and_knee_front_passenger = femur_and_knee_score;
                }

                femur_and_knee_score_le = Math.max(
                    0.0,
                    Math.min(l_femur_comp_f_score, l_knee_comp_score) + femur_and_knee_mod
                );

                femur_and_knee_score_ri = Math.max(
                    0.0,
                    Math.min(r_femur_comp_f_score, r_knee_comp_score) + femur_and_knee_mod
                );
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            /* Overall scores */
            let femur_and_knee_score_var = new Variable(
                templ,
                `${m}_${occ}_FEMUR_AND_KNEE_FINAL_SCORE`,
                "Final femur and knee score",
                femur_and_knee_score.toString(),
                "String",
                false,
                true
            );
            let femur_and_knee_le_score_var = new Variable(
                templ,
                `${m}_${occ}_FEMUR_AND_KNEE_FINAL_LEFT_SCORE`,
                "Final left femur and knee score",
                femur_and_knee_score_le.toString(),
                "String",
                false,
                true
            );
            let femur_and_knee_ri_score_var = new Variable(
                templ,
                `${m}_${occ}_FEMUR_AND_KNEE_FINAL_RIGHT_SCORE`,
                "Final right femur and knee score",
                femur_and_knee_score_ri.toString(),
                "String",
                false,
                true
            );
            let femur_and_knee_mod_var = new Variable(
                templ,
                `${m}_${occ}_FEMUR_AND_KNEE_MODIFIERS`,
                "Final femur and knee modifiers",
                femur_and_knee_mod.toString(),
                "String",
                false,
                true
            );
            let femur_and_knee_score_no_mod_var = new Variable(
                templ,
                `${m}_${occ}_FEMUR_AND_KNEE_SCORE_NO_MOD`,
                "Femur and knee score before applying modifiers",
                femur_and_knee_score_no_mod.toString(),
                "String",
                false,
                true
            );
        }

        frt_row_score = Math.min(femur_and_knee_score_driver, femur_and_knee_front_passenger);

        let frt_row_score_var = new Variable(
            templ,
            `${m}_FRONT_ROW_FEMUR_AND_KNEE_SCORE`,
            `Front row femur and knee final score`,
            frt_row_score.toString(),
            "String",
            false,
            true
        );
    }
}
