/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
draw_occupant_images();

/**
 * Draw occupant body region scoring indicator images for the specified models
 */
function draw_occupant_images() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let output_dir = get_expanded_variable_value(templ, `OUTPUT_DIR`);
    if (!output_dir) {
        LogError(`Could not find OUTPUT_DIR variable for writing occupant image files.`);
        return;
    } else if (!File.IsDirectory(output_dir)) {
        LogError(`OUTPUT_DIR is not a valid directory: ${output_dir}`);
        return;
    }

    let occupants = ["DRIVER", "FRONT_PASSENGER", "REAR_DRIVER_SIDE"];
    for (let m of models) {
        for (let occ of occupants) {
            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            let head_score = get_variable_value(status, `${m}_${occ}_HEAD_FINAL_SCORE`, "float");
            let neck_score = get_variable_value(status, `${m}_${occ}_NECK_FINAL_SCORE`, "float");
            let chest_score = get_variable_value(status, `${m}_${occ}_CHEST_FINAL_SCORE`, "float");

            // Femur and knee, and lower leg (tibia) score only for driver and front passenger
            let femur_and_knee_score_le;
            let femur_and_knee_score_ri;
            let tibia_score_le;
            let tibia_score_ri;
            if (occ == "DRIVER" || occ == "FRONT_PASSENGER") {
                femur_and_knee_score_le = get_variable_value(
                    status,
                    `${m}_${occ}_FEMUR_AND_KNEE_FINAL_LEFT_SCORE`,
                    "float"
                );
                femur_and_knee_score_ri = get_variable_value(
                    status,
                    `${m}_${occ}_FEMUR_AND_KNEE_FINAL_RIGHT_SCORE`,
                    "float"
                );
                tibia_score_le = get_variable_value(status, `${m}_${occ}_TIBIA_LEFT_FINAL_SCORE`, "float");
                tibia_score_ri = get_variable_value(status, `${m}_${occ}_TIBIA_RIGHT_FINAL_SCORE`, "float");
            }

            if (!status.success) {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} body region score indicator images`);
            }

            /* Create new image */
            let img = new Image(190, 342);
            img.lineWidth = 1;
            img.lineColour = "black";

            /* Draw the body regions */
            /*Both */
            draw_front_view_abdomen(img, get_fill_colour_CNCAP(null)); // Not coloured in
            draw_front_view_left_foot(img, get_fill_colour_CNCAP(null));
            draw_front_view_right_foot(img, get_fill_colour_CNCAP(null));
            if (occ == "DRIVER" || occ == "FRONT_PASSENGER") {
                draw_front_view_head(img, get_fill_colour_CNCAP(head_score, 5));
                draw_front_view_neck(img, get_fill_colour_CNCAP(neck_score, 2));
                draw_front_view_chest(img, get_fill_colour_CNCAP(chest_score, 5));
                draw_front_view_left_femur(img, get_fill_colour_CNCAP(femur_and_knee_score_le, 2));
                draw_front_view_right_femur(img, get_fill_colour_CNCAP(femur_and_knee_score_ri, 2));
                draw_front_view_left_tibia(img, get_fill_colour_CNCAP(tibia_score_le, 2));
                draw_front_view_right_tibia(img, get_fill_colour_CNCAP(tibia_score_ri, 2));
            } else {
                draw_front_view_head(img, get_fill_colour_CNCAP(head_score, 1.6));
                draw_front_view_neck(img, get_fill_colour_CNCAP(neck_score, 0.4));
                draw_front_view_chest(img, get_fill_colour_CNCAP(chest_score, 2));
                draw_front_view_left_femur(img, get_fill_colour_CNCAP(null));
                draw_front_view_right_femur(img, get_fill_colour_CNCAP(null));
                draw_front_view_left_tibia(img, get_fill_colour_CNCAP(null));
                draw_front_view_right_tibia(img, get_fill_colour_CNCAP(null));
            }
            draw_front_view_left_arm(img, occ); // Not coloured in; occupant dependent
            draw_front_view_right_arm(img, occ); // Not coloured in; occupant dependent

            if (occ == "DRIVER") {
                draw_front_view_steering_wheel(img);
            }
            draw_front_view_seatbelt(img, occ);

            img.Save(`${output_dir}/${m}_${occ.toLowerCase()}_plot.png`, Image.PNG);
        }
    }
}
