// C-NCAP 2024 Far Side 1-8 template - Get all Head Excursion PNG from model folders
// Since all D3PLOT Head Excursion plots are generated on individual models,
// this script grabs all PNGs into the summary template
// All D3PLOT Head Excursion PNG items will be inactive, and only made active if the PNG files are found
// Then after finish the PNG item generation, the item will be set to inactive again.
/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
get_head_excursion_pictures();

function get_head_excursion_pictures() {
    let templ = Template.GetCurrent();
    let keyword_file = [
        `CASE_1_MODEL_PATH`,
        `CASE_2_MODEL_PATH`,
        `CASE_3_MODEL_PATH`,
        `CASE_4_MODEL_PATH`,
        `CASE_5_MODEL_PATH`,
        `CASE_6_MODEL_PATH`,
        `CASE_7_MODEL_PATH`,
        `CASE_8_MODEL_PATH`
    ];

    let i = 1;
    let str_msg = "已在您输入的模型文件夹中寻找 D3PLOT Head Excursion 图片，其中...\n\n";
    let refresh = false;
    for (let keyword of keyword_file) {
        let dir_obj = Variable.GetFromName(templ, keyword);
        let dir = dir_obj?.value;
        if (dir && File.Exists(dir)) {
            dir = getDirPath(dir);
            LogPrint(`Found ${keyword} in folder: ${dir}`);
            let pic = File.FindFiles(dir, `M1~CNCAP~Far Side Sled~ALL~Head Excursion~HEAD_EXCURSION.png`, true);
            if (pic[0] == null) {
                pic = File.FindFiles(dir, `M1~CNCAP~Far Side Sled~2024 (WSID)~Head Excursion~HEAD_EXCURSION.png`, true);
                if (pic[0] == null) {
                    pic = File.FindFiles(
                        dir,
                        `M1~CNCAP~Far Side Sled~2024 (SID2-SBLD)~Head Excursion~HEAD_EXCURSION.png`,
                        true
                    );
                }
            }
            if (pic[0] != null) {
                LogPrint(`Found: ${pic[0]}`);
                let pic_var = new Variable(
                    templ,
                    `CASE_${i}_HEAD_EXCURSION_PIC`,
                    `CASE_${i}_HEAD_EXCURSION_PIC`,
                    pic[0],
                    "String",
                    false,
                    true
                );
                str_msg = str_msg + `在模型 ${i} 中找到图片 ${pic[0]}\n`;
            } else if (pic[0] == null) {
                // If picture not exist, we write the path variable as "" so later in the script it will skip generating this image item
                LogWarning(`Not found: CASE_${i}_HEAD_EXCURSION_PIC`);
                let pic_var = new Variable(
                    templ,
                    `CASE_${i}_HEAD_EXCURSION_PIC`,
                    `CASE_${i}_HEAD_EXCURSION_PIC`,
                    "",
                    "String",
                    false,
                    true
                );
                refresh = true;
                str_msg =
                    str_msg + `在模型 ${i} 中未找到 max 图片，请对此模型运行 C-NCAP 2024 Far Side 单工况正视图 模板\n`;
            }
            let pic0 = File.FindFiles(dir, `M1~CNCAP~Far Side Sled~ALL~Head Excursion~HEAD_EXCURSION_0MS.png`, true);
            if (pic0[0] != null) {
                LogPrint(`Found: ${pic0[0]}`);
                let pic_var = new Variable(
                    templ,
                    `CASE_${i}_HEAD_EXCURSION_0MS_PIC`,
                    `CASE_${i}_HEAD_EXCURSION_0MS_PIC`,
                    pic0[0],
                    "String",
                    false,
                    true
                );
            } else if (pic0[0] == null) {
                // If picture not exist, we write the path variable as "" so later in the script it will skip generating this image item
                LogWarning(`Not found: CASE_${i}_HEAD_EXCURSION_0MS_PIC`);
                let pic0_var = new Variable(
                    templ,
                    `CASE_${i}_HEAD_EXCURSION_0MS_PIC`,
                    `CASE_${i}_HEAD_EXCURSION_0MS_PIC`,
                    "",
                    "String",
                    false,
                    true
                );
                refresh = true;
                str_msg =
                    str_msg + `在模型 ${i} 中未找到 0ms 图片，请对此模型运行 C-NCAP 2024 Far Side 单工况正视图 模板\n`;
            }
        } else {
            LogWarning(`The ${keyword} is not valid.`);
            let pic_var = new Variable(
                templ,
                `CASE_${i}_HEAD_EXCURSION_PIC`,
                `CASE_${i}_HEAD_EXCURSION_PIC`,
                "",
                "String",
                false,
                true
            );
            let pic0_var = new Variable(
                templ,
                `CASE_${i}_HEAD_EXCURSION_0MS_PIC`,
                `CASE_${i}_HEAD_EXCURSION_0MS_PIC`,
                "",
                "String",
                false,
                true
            );
            str_msg = str_msg + `模型 ${i} 路径不正确/未输入\n`;
        }
        i++;
    }
    if (!Batch()) {
        // If not in batch mode, we use window message to inform user
        Window.Message("搜寻结果", str_msg);
        if (refresh) {
            Window.Message(
                "提示",
                `请对模型文件夹中缺少图片的模型运行《C-NCAP 2024 Far Side 单工况正视图》模板\n` +
                    `当图片在模型文件夹中生成之后，再次点击第 10 页按钮将图片粘贴到此模板中。`
            );
        } else {
            Window.Message("提示", `已将所有模型文件夹中的头部偏移量 0ms / max 图片成功粘贴到此模板中。`);
        }
    }
    // Finish storing all results variables in this template
    // Now we want to generate the Image items in this template, they should have already got file path set as variables
    // If any images do not have file path, the variable will be blank "", we will skip generate those items
    let pages = templ.GetAllPages(); // Array of Page objects
    // Go through all pages
    for (let i = 0; i < pages.length; i++) {
        let this_page = pages[i];
        let items = Item.GetAll(this_page);
        // Go through all items in each page
        for (let j = 0; j < items.length; j++) {
            let this_item = items[j];
            let item_name = this_item.name;
            // Only pick up items with "HEAD_EXCURSION_PIC" in names
            if (item_name.includes("HEAD_EXCURSION_PIC")) {
                let v = Variable.GetFromName(templ, this_item.file.split("%")[1]);
                // If the picture path variable written in item.file is "" then we skip generating this item
                if (v.value != "") {
                    this_item.active = true;
                    this_item.Generate();
                    LogPrint(`Generated ${v.value}`);
                    this_item.active = false;
                }
            }
        }
    }
}

function getDirPath(filePath) {
    filePath = filePath.replace(/\\/g, "/");
    const lastSlashIndex = filePath.lastIndexOf("/");
    return lastSlashIndex === -1 ? "" : filePath.slice(0, lastSlashIndex);
}
