// Creates a report from the report_contents.lst file
// The images and variables should have been created in in generate_report() in T/HIS
// and the OUTPUT_DIR variable should have been set. The report_contents.lst file
//
// TODO - allow user to control the layout of the report. For now it just puts
//        two images per page and assumes the report is landscape
//

read_variables();
create_master_page();
insert_items();
save_template();

/**
 * Creates a master page with header and footer
 */
function create_master_page() {
    let template = Template.GetCurrent();

    let master_page = template.GetMaster();

    /* Header */

    let header_rectangle = new Item(master_page, Item.RECTANGLE);

    header_rectangle.x = 12;
    header_rectangle.x2 = 254;
    header_rectangle.y = 124;
    header_rectangle.y2 = 143;

    header_rectangle.fillColour = Colour.RGB(243, 247, 251);
    header_rectangle.lineColour = Colour.None();

    let regulation = template.GetVariableValue("REGULATION");
    let crash_test = template.GetVariableValue("CRASH_TEST");

    let header_reg_and_crash_test = new Item(master_page, Item.TEXTBOX);

    header_reg_and_crash_test.text = `${regulation} ${crash_test} Occupant Assessment`;
    header_reg_and_crash_test.justify = Reporter.JUSTIFY_LEFT | Reporter.JUSTIFY_MIDDLE;

    header_reg_and_crash_test.x = 21;
    header_reg_and_crash_test.x2 = 161;
    header_reg_and_crash_test.y = 129;
    header_reg_and_crash_test.y2 = 140;

    header_reg_and_crash_test.fontSize = 18;
    header_reg_and_crash_test.fontStyle = Reporter.TEXT_BOLD;

    header_reg_and_crash_test.fillColour = Colour.None();
    header_reg_and_crash_test.lineColour = Colour.None();
    header_reg_and_crash_test.textColour = Colour.RGB(100, 115, 130);

    let version = template.GetVariableValue("VERSION");

    let header_version = new Item(master_page, Item.TEXTBOX);

    header_version.text = `${version}`;

    header_version.justify = Reporter.JUSTIFY_RIGHT | Reporter.JUSTIFY_MIDDLE;

    header_version.x = 161;
    header_version.x2 = 244;
    header_version.y = 129;
    header_version.y2 = 140;

    header_version.fontSize = 12;

    header_version.fillColour = Colour.None();
    header_version.lineColour = Colour.None();
    header_version.textColour = Colour.RGB(204, 208, 214);

    /* Footer */

    let footer_rectangle = new Item(master_page, Item.RECTANGLE);

    footer_rectangle.x = 0;
    footer_rectangle.x2 = 254;
    footer_rectangle.y = 0;
    footer_rectangle.y2 = 12;

    footer_rectangle.fillColour = Colour.RGB(243, 247, 251);
    footer_rectangle.lineColour = Colour.None();

    let footer_text = new Item(master_page, Item.TEXT);

    footer_text.x = 14;
    footer_text.x2 = 249;
    footer_text.y = 6;
    footer_text.y2 = 14;

    footer_text.text = "Model %DEFAULT_DIR%";

    footer_text.justify = Reporter.JUSTIFY_LEFT | Reporter.JUSTIFY_MIDDLE;

    footer_text.fontSize = 6;

    footer_text.textColour = Colour.RGB(100, 115, 130);

    /* Left hand side rectangle */

    let left_hand_side_rectangle = new Item(master_page, Item.RECTANGLE);

    left_hand_side_rectangle.x = 0;
    left_hand_side_rectangle.x2 = 12;
    left_hand_side_rectangle.y = 0;
    left_hand_side_rectangle.y2 = 143;

    left_hand_side_rectangle.fillColour = Colour.RGB(100, 115, 130);
    left_hand_side_rectangle.lineColour = Colour.None();

    let page_number = new Item(master_page, Item.TEXT);

    page_number.text = "%CURRENT_PAGE%/%TOTAL_PAGES%";

    page_number.justify = Reporter.JUSTIFY_CENTRE | Reporter.JUSTIFY_MIDDLE;

    page_number.x = 6;
    page_number.y = 6;

    page_number.fontSize = 8;

    page_number.textColour = Colour.White();
}

/**
 * Reads variables from the VARIABLES_FILENAME file and sets them in the template
 */
function read_variables() {
    let template = Template.GetCurrent();

    let variables_filename = template.GetVariableValue("VARIABLES_FILENAME");

    LogPrint(`Reading variables from: ${variables_filename}`);

    let variables_file = new File(variables_filename, File.READ);

    let line;

    // @ts-ignore - need to update return type of ReadLongLine in reporter.d.ts to string|number
    while ((line = variables_file.ReadLongLine()) != File.EOF) {
        let parsed_line = line.split(",");

        let variable_name = parsed_line[0];
        let variable_value = parsed_line[1];

        LogPrint(`  Setting variable ${variable_name} to ${variable_value}`);

        new Variable(template, variable_name, "", variable_value);
    }

    variables_file.Close();

    LogPrint("Variables read");
}

/**
 * Inserts items into the report, based on the report_contents.lst file
 */
function insert_items() {
    LogPrint("Inserting items into report");

    let template = Template.GetCurrent();

    let report_contents_filename = template.GetVariableValue("REPORT_CONTENTS_FILENAME");

    LogPrint(`  Reading ${report_contents_filename}`);

    let report_contents_file = new File(report_contents_filename, File.READ);

    let item_count = 0;
    let image_count = 0;
    let page_index = 0;

    let page = template.GetPage(page_index++);
    create_page_header(page);

    let line;

    // @ts-ignore - need to update return type of ReadLongLine in reporter.d.ts to string|number
    while ((line = report_contents_file.ReadLongLine()) != File.EOF) {
        let parsed_line = line.split(",");

        let item_type = parsed_line[0];
        let item_filename = parsed_line[1];

        LogPrint(`  Adding ${item_type} ${item_filename}`);

        /* Add a new page every two items
         * and add a textbox for the header */
        if (item_count > 0 && item_count % 2 == 0) {
            page = new Page(template, { index: page_index++ });
            create_page_header(page);
        }

        if (item_type == "IMAGE") {
            item_count++;
            image_count++;

            let name = `autommotive_assessment_image_${image_count}`;
            let item = new Item(page, Item.IMAGE_FILE, name);
            item.file = item_filename;

            set_item_position(item, item_count);
        } else {
            LogError(`Unknown item type ${item_type} in insert_items()`);
        }
    }

    report_contents_file.Close();
}

function save_template() {
    let template = Template.GetCurrent();

    let output_dir = template.GetVariableValue("OUTPUT_DIR");
    let regulation = template.GetVariableValue("REGULATION");
    let crash_test = template.GetVariableValue("CRASH_TEST");
    let version = template.GetVariableValue("VERSION");

    let template_filename = `${output_dir}/${regulation}_${crash_test}_${version}.ortx`;

    LogPrint(`Saving template to ${template_filename}`);

    template.SaveAs(template_filename);

    template.Close();
}

/**
 * @param {Item} item Item to set position for
 * @param {number} item_count The item number in the report
 */
function set_item_position(item, item_count) {
    if (item_count % 2 == 1) {
        item.x = 22;
    } else {
        item.x = 138;
    }

    item.y = 22;

    let width = 106;
    let height = 80;

    item.x2 = item.x + width;
    item.y2 = item.y + height;
}

/* Adds a header to the page */
function create_page_header(page) {
    let item = new Item(page, Item.TEXTBOX);

    item.text = "----- HEADER -----";
    item.justify = Reporter.JUSTIFY_CENTRE | Reporter.JUSTIFY_MIDDLE;

    item.x = 22;
    item.x2 = 244;
    item.y = 109;
    item.y2 = 120;

    item.fontSize = 12;
    item.fontStyle = Reporter.TEXT_BOLD;

    item.fillColour = Colour.RGB(100, 115, 130);
    item.lineColour = Colour.White();
    item.textColour = Colour.White();
}
