// module: TRUE/  
// memory: 1000
// ^^^^^^^^^^^^ important - as importing scripts as modules

// salient file paths as global variables
var install_dir = GetInstallDirectory();
var script_dir = JSPath(arguments[0]);
var module_file_path = install_dir + '/this_library/scripts/MADM/modules/MADM.mjs'; 
var model_file_path = script_dir + "/analysis_model/bouncer.thf";
var madm_config_file = script_dir + "/madm_workflow_test_input.json";

// // extract curves from analysis model for simulation curve
// read in model
var m = Model.Read(model_file_path);

// first, extract displacement-time curve
var f_d = AllocateFlag();
m.SetFlag(f_d, Entity.NODE, -875);
var cur_d = m.GetDataFlagged(f_d, Component.DZ)[0];

// then, extract force-time curve
var f_f = AllocateFlag();
m.SetFlag(f_f, Entity.CONTACT, 1);
var cur_f = m.GetDataFlagged(f_f, Component.CFZ)[0];

// flip displacement time
var cur_d_flipped = Operate.Mul(cur_d, -1);

// filter force-time
var cur_f_filtered = Operate.C180(cur_f)

// then combine displacement-time with force-time + store curve ID
var sim_id = Operate.Com(cur_d_flipped, cur_f_filtered).id;

// run the correlation analysis. Note: madm function is defined below.
madm();

async function madm()
{
    // import the required madm functions from the t/his library
    const { calculateMADM, readjson } = await import(module_file_path);

    // set up input object from JSON configuration file
    var MADM_input = readjson(madm_config_file);

    // set input curves as the appropriate curve IDs
    MADM_input.curve_inputs.sim = sim_id;

    // calculate MADM rating!
    calculateMADM(MADM_input);
}

function JSPath(args_zero) //function that returns the path of this script. note that this is without the forwards slash at the end.
{
    //The following lines define (separately) the path and filename of the JavaScript, for use in relative file mapping etc.:
    let js_split = args_zero.split("/"); //split into directories (forward slash)
    if (js_split.length == 1) js_split = args_zero.split("\\"); //split into directories (Windows backward slash)
    let js_path = js_split[0];
    //var js_name = js_split[js_split.length-1]; //filename (without path) of JavaScript
    for (let i = 1; i < (js_split.length - 1); i++) js_path =  js_path + "/" + js_split[i]; //assembles path (without filename) of JavaScript
    return js_path;
}
