var count, line, x, y, X, Y, ytot, ny;

// Get variable values from template
var curveFile = reporter.currentTemplate.GetVariableValue("CURVE_FILE");
var gateTime  = reporter.currentTemplate.GetVariableValue("GATE_TIME");

// Check that the variables exist
if (curveFile == null) throw Error("no CURVE_FILE variable\n");
if (gateTime  == null) throw Error("no GATE_TIME variable\n");

// Check curve file exists
if (!File.Exists(curveFile)) throw Error("Curve file " + curveFile + " does not exist\n");

// Check f=gateTime is a valid number
var t = parseFloat(gateTime);
if (isNaN(t)) throw Error("Gate time " + gateTime + " is not a valid number\n");

// create a new File object
var file = new File(curveFile, File.READ);

// Zero variables
count = 0;
ytot  = 0;
ny    = 0;

// Keep reading lines from the file until we get to the end of the file
while ( (line = file.ReadLine() ) != File.EOF)
{
    if (line.charAt(0) == '$')
    {
        continue;
    }
    else if (line.match(/CONTINUE/))
    {
        break;
    }
    else
    {
        count++;
// Skip the four title lines at the top of the curve file
        if (count > 4)
        {
// strip leading and trailing apaces
            line = line.replace(/^\s+/, "");
            line = line.replace(/\s+$/, "");

            result = line.match(/([0-9eE+\-\.]+)\s*,?\s*([0-9eE+\-\.]+)/);
            if (result != null)
            {
                x = result[1];
                y = result[2];

// Extract numbers
                X = parseFloat(x);
                Y = parseFloat(y);

// Check that they are valid numbers
                if (isNaN(X)) throw Error("X " + x + " is not a valid number\n");
                if (isNaN(Y)) throw Error("Y " + y + " is not a valid number\n");

// If greater than gate time then include value
                if (X > t)
                {
                    ny++;
                    ytot += Y;
                }
            }
        }
    }
}

// Close the file
file.Close();

// If we have read any values calculate average and set variable
if (ny)
{
    ytot /= ny;

// Create new variable LENGTH
    var ave = new Variable(reporter.currentTemplate, "Y_AVERAGE", "average Y value", ytot);
}
