// Get variable values from template
var x = reporter.currentTemplate.GetVariableValue("X");
var y = reporter.currentTemplate.GetVariableValue("Y");
var z = reporter.currentTemplate.GetVariableValue("Z");

// Check that the variables exist
if (x == null) throw Error("no X variable\n");
if (y == null) throw Error("no Y variable\n");
if (z == null) throw Error("no Z variable\n");

// Extract numbers from variables
var X = parseFloat(x);
var Y = parseFloat(y);
var Z = parseFloat(z);

// Check that the variables are valid numbers
if (isNaN(X)) throw Error("X " + x + " is not a valid number\n");
if (isNaN(Y)) throw Error("Y " + y + " is not a valid number\n");
if (isNaN(Z)) throw Error("Z " + z + " is not a valid number\n");

// Calculate magnitude
var length = Math.sqrt(X*X + Y*Y + Z*Z);

// Check for valid magnitude
if (isNaN(length)) throw Error("Bad vector magnitude\n");

// Create new variable LENGTH
var lvar = new Variable(reporter.currentTemplate, "LENGTH", "vector magnitude", length);
