var percent;

// Get variable values from template
var value      = reporter.currentTemplate.GetVariableValue("VALUE");
var base_value = reporter.currentTemplate.GetVariableValue("VALUE_BASE");

// Check that the variables exist
if (value      == null) throw Error("no VALUE variable\n");
if (base_value == null) throw Error("no VALUE_BASE variable\n");

// Extract numbers from variables
var v  = parseFloat(value);
var bv = parseFloat(base_value);

// Check that the variables are valid numbers
if (isNaN(v))  throw Error("VALUE " + value + " is not a valid number\n");
if (isNaN(bv)) throw Error("VALUE_BASE " + base_value + " is not a valid number\n");

// Check for zero (very small) base value
if (Math.abs(bv) < 1.0e-20)
    percent = 100;
else
    percent = 100*((v-bv)/bv);

// Create new variable PERCENT
var pvar = new Variable(reporter.currentTemplate, "PERCENT", "Percent change", percent.toFixed(2));
