var m = new Model();

Message("Making elastic material");

var mat = new Material(m, 1, "ELASTIC");

Message("Material has " + mat.properties + " properties");


Message("Getting properties by index");
var np = mat.properties;
var pnames = new Object();

for (i=0; i<np; i++)
{
    Message(mat.GetPropertyNameForIndex(i) + "=" + mat.GetPropertyByIndex(i));

    pnames[mat.GetPropertyNameForIndex(i)] = true;
}

Message("Getting properties by name");
for (p in pnames)
{
    Message(p+"=" + mat.GetPropertyByName(p));
}

Message("Setting properties by name");
i = 0;
for (p in pnames)
{
    mat.SetPropertyByName(p, ++i);
    Message(p+"=" + i);
}

Message("Getting properties by name");
for (p in pnames)
{
    Message(p+"=" + mat.GetPropertyByName(p));
}

Message("Changing type...");
mat.type = "PLASTIC_KINEMATIC";

Message("Type is now " + mat.type);

Message("Getting properties by index");
var np = mat.properties;
for (i=0; i<np; i++)
    Message(mat.GetPropertyNameForIndex(i) + "=" + mat.GetPropertyByIndex(i));

Message("Setting properties by index");
var np = mat.properties;
for (i=0; i<np; i++)
{
    mat.SetPropertyByIndex(i, (i+1)*1.1);
    Message("index "+i+"=" + (i+1)*1.1);
}

Message("Getting properties by row/col");
for (r=0; r<mat.rows; r++)
{
    for (c=0; c<mat.cols; c++)
    {
        Message(r+" "+c+" " + mat.GetPropertyNameForRowCol(r, c) + "=" + mat.GetPropertyByRowCol(r, c));
    }
}

