var w = new Window("Read file", 0.8, 1.0, 0.5, 0.6);

var l = new Widget(w, Widget.LABEL,    1, 30, 1, 7, "File:");
var t = new Widget(w, Widget.TEXTBOX, 31, 80, 1, 7, "");
var s = new Widget(w, Widget.BUTTON,   1, 27, 8, 14, "Select");
var r = new Widget(w, Widget.BUTTON,  28, 53, 8, 14, "Read");
var q = new Widget(w, Widget.BUTTON,  54, 80, 8, 14, "Quit");

t.onChange = update;
r.onClick = read;
s.onClick = select;
q.onClick = Exit;
r.active  = false;

w.Show();


function update()
{
    if (t.text) r.active = true;
}


function select()
{
    var fname = Window.GetOpenFile("neu");
    Message("Selected file " + fname);
    if (fname) t.text = fname;
    update();
}

function read()
{
    var line;
    var section = "";

    var m = new Model();

    Message("Text in textbox is " + t.text);

    var f = new File(t.text, File.READ);

    while (line = f.ReadLine() )
    {
        if (line.match(/ENDOFSECTION/))
        {
            section = "";
        }
        else if (section == "nodes")
        {
            line = line.replace(/^\s+/, "");
            line = line.replace(/\s+$/, "");
            var ndata = line.split(/\s+/);
            var n = new Node(m, parseInt(ndata[0]), parseFloat(ndata[1]), parseFloat(ndata[2]), parseFloat(ndata[3]) );
        }
        else if (section == "elements")
        {
            line = line.replace(/^\s+/, "");
            line = line.replace(/\s+$/, "");
            var d = line.split(/\s+/);
            d.splice(2, 1);
            for (i=0; i<d.length; i++)
                d[i] = parseInt(d[i]);

            var line2 = f.ReadLine()
            line2 = line2.replace(/^\s+/, "");
            line2 = line2.replace(/\s+$/, "");
            d.push(parseInt(line2));

// need to swap n3<=>n4 and n7<=>n8
            var s = new Solid(m, d[0], d[1], d[2], d[3], d[5], d[4], d[6], d[7], d[9], d[8]);
        }
        else if (line.match(/NODAL COORDINATES/))
        {
            section = "nodes";
        }
        else if (line.match(/CELLS/))
        {
            section = "elements";
        }
    }

    f.Close();

    m.UpdateGraphics();
    View.Ac();

    Exit();
}
