// Example to show to use array buffers and read and write them from file
// Miles Thornton 6/2/15

// Make array buffer with length 100 bytes
var ab = new ArrayBuffer(100);

// Make array buffer view on buffer to store 8bit unsigned ints
var uint8   = new Uint8Array(ab);

// Make array buffer view on buffer offset by 4 bytes to store 32bit unsigned ints
// You can omit the offset and handle it yourself if you want.
// Look at read example further down
var uint32  = new Uint32Array(ab, 4);

// Make array buffer view on buffer offset by 12 bytes to store 32bit floats
var float32 = new Float32Array(ab, 12);

// Assign some values
uint8[0] = 0;		// Byte offset 0 in ab
uint8[1] = 255;
uint8[2] = 40;
uint8[3] = 80;
uint32[0] = 12345678;	// Byte offset 4 in ab
uint32[1] = 87654321;
float32[0] = 0.0;	// Byte offset 12 in ab
float32[1] = 1.0;
float32[2] = 3.1415926;
float32[3] = 1.2345678;	// Length of data is 28 bytes

// Open file for writing
var f = new File("binary_file", File.WRITE|File.BINARY);

// Write array buffer to file
f.WriteArrayBuffer(ab, 28);

// Close file
f.Close();

// Open file for reading
var f = new File("binary_file", File.READ|File.BINARY);

// Read ArrayBuffer
var ab = f.ReadArrayBuffer();
Message("Length of array buffer = "+ab.byteLength);

// Close file
f.Close();

// Set up array buffers for reading
// Note that in this case we have not set offsets so see array indices.
var uint8   = new Uint8Array(ab);
var uint32  = new Uint32Array(ab);
var float32 = new Float32Array(ab);

// Read data from array buffer and populate array
var data = [];
data.push(uint8[0]);
data.push(uint8[1]);
data.push(uint8[2]);
data.push(uint8[3]);
data.push(uint32[1]);
data.push(uint32[2]);
data.push(float32[3]);
data.push(float32[4]);
data.push(float32[5]);
data.push(float32[6]);

for (var d=0; d<data.length; d++)
    Message(d+": "+ data[d]);
