# Run the 4 PERL scripts that generate the JS API manual
#
# Mario Mata
# 23/05/2023
#
import subprocess
import os

#Create temporary files
file1 = open("PRIMER/js_api.xml", "w")
file2 = open("D3PLOT/js_api.xml", "w")
file3 = open("THIS/js_api.xml", "w")
file4 = open("REPORTER/js_api.xml", "w")

file1.close()
file2.close()
file3.close()
file4.close()


#Run the api_XXXXX.pl scrip for each of the 4 programs to generate the htm files
print("Generating PRIMER files...")
pipe=subprocess.Popen(['perl','perl/api_PRIMER.pl'],stdout=subprocess.PIPE)
out, err = pipe.communicate()

print("Generating D3PLOT files...")
pipe=subprocess.Popen(['perl','perl/api_D3PLOT.pl'],stdout=subprocess.PIPE)
out, err = pipe.communicate()

print("Generating T/HIS files...")
pipe=subprocess.Popen(['perl','perl/api_THIS.pl'],stdout=subprocess.PIPE)
out, err = pipe.communicate()

print("Generating REPORTER files...")
pipe=subprocess.Popen(['perl','perl/api_REPORTER.pl'],stdout=subprocess.PIPE)
out, err = pipe.communicate()


#Run create_tree.pl to generate the tree
print("Creating tree...")
pipe=subprocess.Popen(['perl','perl/create_tree.pl'],stdout=subprocess.PIPE)
out, err = pipe.communicate()


#Delete temporary files
if os.path.exists("PRIMER/js_api.xml"): os.remove("PRIMER/js_api.xml")
if os.path.exists("D3PLOT/js_api.xml"): os.remove("D3PLOT/js_api.xml")
if os.path.exists("THIS/js_api.xml"): os.remove("THIS/js_api.xml")
if os.path.exists("REPORTER/js_api.xml"): os.remove("REPORTER/js_api.xml")
