#!/bin/csh -f
#
set HOSTNAME   = `hostname`
#
# Set the INSTALL directory and the executable base name
#
set version          = "22"
set Brand            = "Oasys Ltd. LS-DYNA Environment"             # "Oasys Ltd. LS-DYNA Environment" 
set prefix           = "oa"                                         # Prefix for directory/shell name. "oa" 
set subversion       = "1"
set INSTALL          = "${Brand} ${version}.${subversion} COMPLETE "
set this_version     = "T-HIS ${version}.${subversion}"
set primer_version   = "PRIMER ${version}.${subversion}"
set d3plot_version   = "D3PLOT ${version}.${subversion}"
set reporter_version = "REPORTER ${version}.${subversion}"
set shell_version    = "SHELL ${version}.${subversion}"
set lmxver           = "5.6.4"
#
#
# for CD installation we will already be in right directory
# so just get on with it
#
if(-e .cd) then
 set install_dir = `pwd`
 set oasys_dir = "$install_dir/${prefix}${version}"
 echo " "
 goto take_it_from_here
endif
#
# for web installation give intro blurb and directory choice
#
clear
echo "${Brand} ${version}.${subversion} Installation"
echo "================================================"
echo " "
echo "This script will install the following programs on $HOSTNAME"
echo " "
echo "     "$d3plot_version
echo "     "$primer_version
echo "     "$reporter_version
echo "     "$shell_version
echo "     "$this_version
echo " "
#
# First checking whether user's computer has the right prerequisites
#
echo "Checking prerequisites ..."
#
# List of X11 libraries that are required for Qt6
#
set libraryList = ("libxcb-cursor.so" "libxcb-icccm.so" "libxcb-image.so" \
"libxcb-keysyms.so" "libxcb-randr.so" "libxcb-render-util.so" "libxcb-shm.so" \
"libxcb-sync.so" "libxcb-xfixes.so" "libxcb-render.so" "libxcb-shape.so" "libxcb-xkb.so" \
"libxcb-util.so" "libxkbcommon.so" "libxkbcommon-x11.so" "libXau.so" "libX11-xcb.so" \
"libxcb.so" "libX11.so") 
set missing = 0
#
# Iterate over the list and check if each library is installed
#
foreach lib ($libraryList)
    ldconfig -p | grep $lib > /dev/null
    if ( $status != 0 ) then
        echo "$lib not found"
        set missing = 1
    endif
end
#
# Check if any library was missing. Just in case ldconfig doesn't work,
# giving the user the option to continue with the installation regardless.
#
if ($missing == 1) then
    echo "Some library prerequisites are missing."

    missing_prereq:
    set buffer = ()
    while ( $#buffer == 0 )
    echo " "
    echo -n "Would you like to still continue with the ${Brand} installation? (Y/N)"
    set buffer = $<
    if ( "$buffer" == "" ) set buffer = ()
    end
    set answer = `echo "$buffer[1]" | tr "[A-Z]" "[a-z]"`
    switch ($answer)
        case yes:
        case ye:
        case y:
            echo "Please consult the Installation Guide on how to install the libraries after this is done."
            breaksw
        case no:
        case n:
            echo "Please consult the Installation Guide on how to install the libraries and try again."
            goto exit
            breaksw
        case quit:
        case qui:
        case qu:
        case q:
            goto exit
            breaksw
        default:
            goto missing_prereq 
            breaksw
    endsw
else
    echo "All library prerequisites are installed."
endif
#
# For _0 release don't give the option
# Comment out the following two lines for _1 release,etc
#
#set install_type = "full"
#goto get_dir
#
echo "Please select one of the following installation options :"
echo " "
echo "FULL   -  This will install the programs along with all of the files"
echo "          required for ${Brand}"
echo " "
echo "UPDATE -  This will install just programs along with a copy of the"
echo "          latest preference file."
echo "          Note that this will also update the library directories"
echo "          for all the software. If you have your own scripts in"
echo "          these directories they will not be deleted, but if you"
echo "          have modified any of the scripts given out with the"
echo "          ${Brand} package your changes will be overwritten."
echo "          If this is the case, please backup your modified scripts"
echo "          before continuing."
echo " "
#
# Get the installation type
#
get_install:
set buffer = ()
while ( $#buffer == 0 )
  echo -n "Select FULL/UPDATE or QUIT(to exit installation) ... "
  set buffer = $<
  if ( "$buffer" == "" ) set buffer = ()
end
set answer = `echo "$buffer[1]" | tr "[A-Z]" "[a-z]"`
switch ($answer)
  case full:
  case ful:
  case fu:
  case f:
    set install_type = "full"
    breaksw
  case update:
  case updat:
  case upda:
  case upd:
  case up:
  case u:
    set install_type = "update"
    breaksw
  case quit:
  case qui:
  case qu:
  case q:
    goto exit
    breaksw
  default:
  goto get_install
endsw
#
get_dir:
set install_dir = `pwd`
set oasys_dir = "$install_dir/${prefix}${version}"
set install_directory = "no"
#
echo " "
echo "Installation directory : $oasys_dir"
#
set buffer = ()
while ( $#buffer == 0 )
  echo " "
  echo -n "Do you want to change the installation directory? (Y/N/Quit) "
  set buffer = $<
  if ( "$buffer" == "" ) set buffer = ()
end
set answer = `echo "$buffer[1]" | tr "[A-Z]" "[a-z]"`
switch ($answer)
  case no:
  case n:
    breaksw
  case yes:
  case ye:
  case y:
    get_directory:
    set install_dir = ()
    echo " "
    echo "Enter the FULL PATH of the directory into which you want to"
    echo "put the software."
    echo " "
    echo -n " ? : "
    set install_dir = $<
    if("$install_dir" == "") goto get_directory
    set oasys_dir = "$install_dir"
    set install_directory = "yes"
    breaksw
  case quit:
  case qui:
  case qu:
  case q:
    goto exit
    breaksw
default:
  goto get_dir
endsw

set_directory:
if ( "$install_directory" == "yes") then
  echo " "
  echo "Installation directory : $oasys_dir"
  set buffer = ()
  while ( $#buffer == 0 )
    echo " "
    echo -n "Are you sure you want to install in this directory? [Y/N] "
    set buffer = $<
    if ( "$buffer" == "" ) set buffer = ()
  end
set answer = `echo "$buffer[1]" | tr "[A-Z]" "[a-z]"`
switch ($answer)
  case yes:
  case ye:
  case y:
    breaksw
  case no:
  case n:
    get_directory_bis:
    set install_dir = ()
    echo " "
    echo "Enter the FULL PATH of the directory into which you want to"
    echo "put the software."
    echo " "
    echo -n " ? : "
    set install_dir = $<
    if("$install_dir" == "") goto get_directory_bis
    set oasys_dir = "$install_dir"
    set install_directory = "yes"
    goto set_directory 
    breaksw
  case quit:
  case qui:
  case qu:
  case q:
    goto exit
    breaksw
default:
    goto set_directory 
    breaksw
endsw
endif
#
echo " "
echo "${Brand} will be installed in the directory:"
echo " "
echo $oasys_dir
#
#
#
take_it_from_here:
#
# try and create the directory
#
set status = 0
#
mkdir -p -m 755 $oasys_dir >& /dev/null
if ($status != 0) then
  echo " "
  echo "ERROR : unable to create $oasys_dir"
  echo " "
  goto exit 
endif
#
# Create a subdirectory for the LMX server stuff
#
set lmx_dir = "$install_dir/lmx-$lmxver"
mkdir -p -m 755 $lmx_dir  >& /dev/null
if ($status != 0) then
  echo " "
  echo "ERROR : unable to create $lmx_dir"
  echo " "
  goto exit
endif

#
# see if primer executable of this name already exists
#
set exists = 0
if(-e $oasys_dir/primer${version}_${subversion}_64.exe) then
echo " "
echo "WARNING PRIMER executable found in installation directory"
set exists = 1
endif
if(-e $oasys_dir/d3plot${version}_${subversion}_64.exe) then
echo " "
echo "WARNING D3PLOT executable found in installation directory"
set exists = 1
endif
if(-e $oasys_dir/this${version}_${subversion}_64.exe) then
echo " "
echo "WARNING T/HIS executable found in installation directory"
set exists = 1
endif
if(-e $oasys_dir/reporter${version}_${subversion}_64.exe) then
echo " "
echo "WARNING REPORTER executable found in installation directory"
set exists = 1
endif
if(-e $oasys_dir/femzip_reader${version}_${subversion}_64.exe) then
echo " "
echo "WARNING Femzip_reader executable found in installation directory"
set exists = 1
endif
if(-e $oasys_dir/xshell_${version}_${subversion}_64) then
echo " "
echo "WARNING SHELL executable found in installation directory"
set exists = 1
endif

if($exists == 1) then

  set buffer = ()

  while ( $#buffer == 0 )
    echo " "
    echo -n "Continue installing in this directory - overwriting these files? [Y/N] "
    set buffer = $<
    if ( "$buffer" == "" ) set buffer = ()
  end

  set answer = `echo "$buffer[1]" | tr "[A-Z]" "[a-z]"`

  switch ($answer)
    case yes:
    case ye:
    case y:   
	breaksw

    default:  
	goto exit
        
  endsw

endif

# What we install depends on the installation type
#
if ( $install_type == "full" ) then
#
  echo -n "Copying files ......"
#
# LMX
#
  if(-e lmx_server${version}_${subversion}.tar) then
    if(! -e $lmx_dir/lmx_server${version}_${subversion}.tar) then
      cp lmx_server${version}_${subversion}.tar $lmx_dir/.
    endif
  else
    echo " "
    echo "Cannot find LMX file: lmx_server${version}_${subversion}.tar...."
  endif
#
# lmxendutil
# note: this lmxendutil is always unpacked for end user's usage
#       lmx.tar above is only used if installing LMX server
#
  if(-e licutil.tar) then
    cp licutil.tar $oasys_dir
  else
    echo " "
    echo "Cannot find licensing util file: licutil.tar...."
  endif
# Environment (shell etc)
#
  if(-e environment.tar) then
    cp environment.tar $oasys_dir
  else
    echo " "
    echo "Cannot find Environment file: environment.tar...."
  endif
#
# T/HIS macros (optional)
#
  if(-e macros.tar) then
    cp macros.tar $oasys_dir
  endif
#
endif
#
# Actual software being installed
#
if(-e peripheral.tar) then
  cp peripheral.tar $oasys_dir
else
  echo " "
  echo "Cannot find software file: peripheral.tar. Aborting ..."
  goto exit
endif
#
#
if(-e manuals.tar.gz) then
  echo -n "Copying manuals ......"
  cp manuals.tar.gz $oasys_dir
endif
#
#
if(-e libraries.tar) then
  cp libraries.tar $oasys_dir
endif
#
# Workflows
#
if(-e workflows.tar) then
  cp workflows.tar $oasys_dir
endif
#
# Now start unpacking the files
# 
cd $oasys_dir
#
#
if(-e manuals.tar.gz) then
  echo -n "Uncompressing manuals ......"
  gunzip -f manuals.tar.gz
  if ($status != 0) then
    echo  " ERROR : unable to uncompress files using gunzip. Aborting ..."
    echo  "         Please install gzip on your machine and try again."
    goto exit
  else
    echo -n "Unpacking manuals .........."
    tar xvf manuals.tar >& /dev/null
    if ($status != 0) then
      echo  " ERROR : unable to copy all files. Check directory Permissions"
      echo  "         and available disk space. Aborting ..."
      goto exit
    else
      rm -f manuals.tar
      echo " Complete"
    endif
  endif
endif
#
if(-e licutil.tar) then
  echo -n "Unpacking license util files ....."
  tar xvf licutil.tar >& /dev/null
  if ($status != 0) then
    echo  " ERROR : unable to copy all files. Check directory Permissions"
    echo  "         and available disk space. Aborting ..."
    goto exit
  else
    rm -f licutil.tar
    echo " Complete"
  endif
endif
#
if(-e macros.tar) then
  echo -n "Unpacking macros ..........."
  tar xvf macros.tar >& /dev/null
  if ($status != 0) then
    echo  " ERROR : unable to copy all files. Check directory Permissions"
    echo  "         and available disk space. Aborting ..."
    goto exit
  else
    rm -f macros.tar
    echo " Complete"
  endif
endif
#
if(-e environment.tar) then
  echo -n "Unpacking environment ......"
  tar xvf environment.tar >& /dev/null
  if ($status != 0) then
    echo  " ERROR : unable to copy all files. Check directory Permissions"
    echo  "         and available disk space. Aborting ..."
    goto exit
  else
    rm -f environment.tar
    echo " Complete"
  endif
endif
#
if(-e workflows.tar) then
  echo -n "Unpacking workflows ......"
  tar xvf workflows.tar >& /dev/null
  if ($status != 0) then
    echo  " ERROR : unable to copy all files. Check directory Permissions"
    echo  "         and available disk space. Aborting ..."
    goto exit
  else
    rm -f workflows.tar
    echo " Complete"
  endif
endif
#
echo -n "Unpacking ${Brand} Software ..."
tar xvf peripheral.tar >& /dev/null
if ($status != 0) then
  echo  " ERROR : unable to copy all files. Check directory Permissions"
  echo  "         and available disk space. Aborting ..."
  goto exit
else
  rm -f peripheral.tar

  echo " Complete"
endif
#
if(-e libraries.tar) then
  echo -n "Unpacking libraries ..........."
  tar xvf libraries.tar >& /dev/null
  if ($status != 0) then
    echo  " ERROR : unable to copy all files. Check directory Permissions"
    echo  "         and available disk space. Aborting ..."
    goto exit
  else
    rm -f libraries.tar
    echo " Complete"
  endif
endif
#
echo -n "Uncompressing files ........"
gunzip -f *.gz
if ($status != 0) then
  echo  " ERROR : unable to uncompress files using gunzip. Aborting ..."
  echo  "         Please install gzip on your machine and try again."
  goto exit
else
  chmod -R 755 *

# Make links so primer14_64.exe links to primer14_0_64.exe or whatever
# unconditionally delete the old one first

  echo "Making soft links ..."

  if(-e primer${version}_64.exe)        rm -f primer${version}_64.exe
  if(-e d3plot${version}_64.exe)        rm -f d3plot${version}_64.exe
  if(-e this${version}_64.exe)          rm -f this${version}_64.exe
  if(-e reporter${version}_64.exe)      rm -f reporter${version}_64.exe
  if(-e femzip_reader${version}_64.exe) rm -f femzip_reader${version}_64.exe
  if(-e xshell_${version}_64)           rm -f xshell_${version}_64

  ln -s primer${version}_${subversion}_64.exe        primer${version}_64.exe
  ln -s d3plot${version}_${subversion}_64.exe        d3plot${version}_64.exe
  ln -s this${version}_${subversion}_64.exe          this${version}_64.exe
  ln -s reporter${version}_${subversion}_64.exe      reporter${version}_64.exe
  ln -s femzip_reader${version}_${subversion}_64.exe femzip_reader${version}_64.exe
  ln -s xshell_${version}_${subversion}_64           xshell_${version}_64

  echo " Complete"
endif
#
#
#
# Look to see if the directory already contains a oa_pref file.
#
if (-e oa_pref) then
  echo " "
  echo "******************************************************************************"
  echo "WARNING"
  echo " "
  echo "The installation directory already contains an oa_pref file"
  echo "The new preference file has been installed as oa_pref_64" 
  echo "You may wish to edit it and rename as oa_pref"
  echo " "
  echo "******************************************************************************"
  echo " "
else
  echo "Installing oa_pref file ..."
  mv oa_pref_64 oa_pref
endif

#
# Configure script files using ex if it is a full install 
#

if ( $install_type == "update" ) goto manuals
#
echo " "
echo "Configuring script files ..."
#
set buffer = ()
while ( $#buffer == 0 )
  echo " "
  echo -n "Do you want to set up ${Brand} to use a LMX License server? [Y/N] "
  set buffer = $<
  if ( "$buffer" == "" ) set buffer = ()
end
set answer = `echo "$buffer[1]" | tr "[A-Z]" "[a-z]"`
switch ($answer)
  case yes:
  case ye:
  case y:
    echo " "
    echo "Enter the hostname/ip address of the server"
    echo " "
    set buffer = ()
    while ( $#buffer == 0 )
      echo -n " ? : "
      set buffer = $<
      if ( "$buffer" == "" ) set buffer = ()
    end
    set lmx_server = `echo "$buffer[1]" | tr "[A-Z]" "[a-z]"`
    set server = "yes"
    breaksw
  default:
    set lmx_server = '$OA_INSTALL/arup.lic'
    set server = "no"
    echo " "
    echo 'Using: setenv ARUP_LICENSE_PATH $OA_INSTALL/arup.lic'
    echo " "
    echo "*****************************************************************************"
    echo "If you already have a node locked license copy it into the ${prefix}${version} directory"
    echo "*****************************************************************************"
endsw

lmx_server:
if ( "$server" == "yes") then
  echo " "
  echo "Using: setenv ARUP_LICENSE_PATH @"$lmx_server
  set buffer = ()
  while ( $#buffer == 0 )
    echo " "
    echo -n "Are you sure you want this to be your ${Brand} LMX server? [Y/N] "
    set buffer = $<
    if ( "$buffer" == "" ) set buffer = ()
  end
set answer = `echo "$buffer[1]" | tr "[A-Z]" "[a-z]"`
switch ($answer)
  case yes:
  case ye:
  case y:
    breaksw
  case no:
  case n:
    echo " "
    echo "Enter the hostname/ip address of the server"
    echo " "
    set buffer = ()
    while ( $#buffer == 0 )
      echo -n " ? : "
      set buffer = $<
      if ( "$buffer" == "" ) set buffer = ()
    end
    set lmx_server = `echo "$buffer[1]" | tr "[A-Z]" "[a-z]"`
    set server = "yes"
    goto lmx_server
    breaksw
  case quit:
  case qui:
  case qu:
  case q:
    goto exit
    breaksw
default:
    goto lmx_server
    breaksw
endsw
endif
#
# Now extract the LMX server files
#
echo -n "Creating installation files for LMX server ......"
#
cd $lmx_dir
#
if(-e lmx_server${version}_${subversion}.tar) then
  echo "Unpacking LMX files ....."
  tar xvf lmx_server${version}_${subversion}.tar >& /dev/null
  if ($status != 0) then
    echo  " ERROR : unable to copy all LMX-related files. Check directory Permissions"
    echo  "         and available disk space. Aborting ..."
    goto exit
  else
    rm -f lmx_server${version}_${subversion}.tar
    echo  " "
    echo  " The LMX server installation files have been installed in $lmx_dir"
    echo  " "
    echo  " If you want to install the LMX License server run lmx-enduser-tools_v${lmxver}_linux_x64.sh"
    echo  " after this installaton script has completed."
  endif
endif
#
# See if they want to setup an Admin directory
#
get_admin:
set admin_dir = `pwd`
set admin = 'no'
set buffer = ()
while ( $#buffer == 0 )
  echo " "
  echo -n "Do you want to set up an OA_ADMIN directory? [Y/N] "
  set buffer = $<
  if ( "$buffer" == "" ) set buffer = ()
end
set answer = `echo "$buffer[1]" | tr "[A-Z]" "[a-z]"`
switch ($answer)
  case no:
  case n:
    breaksw
  case yes:
  case ye:
  case y:
    get_admin_directory:
    set admin_dir = ()
    echo " "
    echo "Enter the FULL PATH of the OA_ADMIN directory"
    echo " "
    echo -n " ? : "
    set admin_dir = $<
    if("$admin_dir" == "") goto get_admin_directory
    set admin = 'yes'
    breaksw
  case quit:
  case qui:
  case qu:
  case q:
    goto exit
    breaksw
default:
    goto get_admin
    breaksw
endsw

admin_directory:
if ( "$admin" == "yes") then
  echo " "
  echo "OA_ADMIN directory : $admin_dir"
  set buffer = ()
  while ( $#buffer == 0 )
    echo " "
    echo -n "Are you sure you want this directory to be your OA_ADMIN directory? [Y/N] "
    set buffer = $<
    if ( "$buffer" == "" ) set buffer = ()
  end
set answer = `echo "$buffer[1]" | tr "[A-Z]" "[a-z]"`
switch ($answer)
  case yes:
  case ye:
  case y:
    breaksw
  case no:
  case n:
    get_admin_directory_bis:
    set admin_dir = ()
    echo " "
    echo "Enter the FULL PATH of the OA_ADMIN directory"
    echo " "
    echo -n " ? : "
    set admin_dir = $<
    if("$admin_dir" == "") goto get_admin_directory_bis
    set admin = 'yes'
    goto admin_directory
    breaksw
  case quit:
  case qui:
  case qu:
  case q:
    goto exit
    breaksw
default:
    goto admin_directory
    breaksw
endsw
endif
#
# substitute in ${prefix}_${version} file
#
echo "%s;XXXX1;$oasys_dir"";" > $oasys_dir/ex_script
if ( "$server" == "yes") then
  echo "%s;XXXX2;$lmx_server"";" >> $oasys_dir/ex_script
else
  echo "%s;@XXXX2;$lmx_server"";" >> $oasys_dir/ex_script
endif
#
set admin2 = \"${admin_dir}\"
#
if ( "$admin" == "yes") then
  echo "%s;XXXX3;  setenv OA_ADMIN $admin2"";" >> $oasys_dir/ex_script
else
  echo "%s;XXXX3;# setenv OA_ADMIN;" >> $oasys_dir/ex_script
endif
#
echo "wq" >> $oasys_dir/ex_script
ex $oasys_dir/${prefix}_${version} < $oasys_dir/ex_script >& /dev/null
rm -f $oasys_dir/ex_script
#
echo " "
echo "Installation script has run OK"
# for CD install tell calling script that everything is ok 
if(-e ../.cd) touch .ok
echo " "
echo "Please read the Installation and Maintenance Instructions for details on how"
echo "to obtain your license codes."
#
manuals:
#
if(! -e $oasys_dir/manuals) then
 echo " "
 echo "When manuals are available please download the file"
 echo " "
 echo " manuals.tar.gz (from www.arup.com/dyna/downloads/documentation)"
 echo " "
 echo "into the ${prefix}${version} directory. Then Gunzip and Untar to create <manuals> dir."
endif
#
# extra message for CD case
cd ..
if(! -e .cd) then
 echo " "
 echo "Installation script has run successfully."
 echo " "
 echo "The following files can now be removed:"
 if(-e $oasys_dir/manuals) then
   echo "environment.tar, lmx_server${version}_${subversion}.tar, licutil.tar, peripheral.tar, libraries.tar, workflows.tar, setup.csh, manuals.tar.gz"
 else
   echo "environment.tar, lmx_server${version}_${subversion}.tar, licutil.tar, peripheral.tar, libraries.tar, workflows.tar, setup.csh"
 endif
 echo " "
endif
#
exit
#
exit:
echo " "
echo "Installation script has failed :-("
exit
